/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.Utils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class XType {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static Long getLong(String string) {
        return string == null ? null : Long.valueOf(Long.parseLong(string));
    }

    public static Integer getInt(String string) {
        return string == null ? null : Integer.valueOf(Integer.parseInt(string));
    }

    public static Boolean getBoolean(String string) {
        return string == null ? null : Boolean.valueOf("true".equalsIgnoreCase(string));
    }

    public static Date getDate(String string) {
        return Utils.dateFromString((String)string);
    }

    public static String toString(long value) {
        return "" + value;
    }

    public static String toString(int value) {
        return "" + value;
    }

    public static String toString(boolean value) {
        return "" + value;
    }

    public static String toString(double value) {
        long lval = Math.round(value);
        if (Math.abs(value - (double)lval) < 0.001) {
            return "" + lval;
        }
        DecimalFormat fmt = (DecimalFormat)NumberFormat.getInstance(Locale.ROOT);
        fmt.applyPattern("#.#########");
        return fmt.format(value);
    }

    public static String toString(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        SimpleDateFormat format = new SimpleDateFormat(value.getTime() % 1000L == 0L ? DATE_FORMAT : DATE_FORMAT_MS);
        format.setTimeZone(GMT);
        return format.format(value);
    }

    public static String toString(Date value, String dateFormat) {
        if (value == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        format.setTimeZone(GMT);
        return format.format(value);
    }

    public static String sizeToString(long size) {
        double s = (double)size / 1024.0 / 1024.0;
        return String.format("%.3f MB", s);
    }

    public static long stringToSize(String str) {
        if (str == null) {
            return 0L;
        }
        str = str.substring(0, str.length() - 3);
        try {
            double d = NumberFormat.getInstance(Locale.ROOT).parse(str).doubleValue();
            return (long)(d * 1024.0 * 1024.0);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

