/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.XType;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ParsedQuery {
    private Set<String> requestedKeys;
    private Map<String, String> map;

    public ParsedQuery(String requiredNodeName, UNode node) {
        assert (requiredNodeName != null);
        assert (node != null);
        this.map = new HashMap<String, String>();
        Utils.require((node.isMap() && requiredNodeName.equals(node.getName()) ? 1 : 0) != 0, (String)("Root node should be a map called '" + requiredNodeName + "': " + node));
        for (UNode childNode : node.getMemberList()) {
            Utils.require((boolean)childNode.isValue(), (String)(childNode + " parameter value must be text"));
            String paramName = childNode.getName();
            String paramValue = childNode.getValue();
            Utils.require((!this.map.containsKey(paramName) ? 1 : 0) != 0, (String)(String.valueOf(paramName) + " can only be specified once"));
            this.map.put(paramName, paramValue);
        }
    }

    public ParsedQuery(String queryParam) throws IllegalArgumentException {
        this.map = Utils.parseURIQuery((String)queryParam);
    }

    public String get(String key) {
        if (this.requestedKeys == null) {
            this.requestedKeys = new HashSet<String>();
        }
        String value = this.map.get(key);
        this.requestedKeys.add(key);
        return value;
    }

    public String getString(String key) {
        String value = this.get(key);
        Utils.require((value != null ? 1 : 0) != 0, (String)(String.valueOf(key) + " parameter is not set"));
        return value;
    }

    public Date getDate(String key) {
        String value = this.get(key);
        Date result = Utils.isEmpty((String)value) ? null : Utils.dateFromString((String)value);
        return result;
    }

    public int getInt(String key) {
        String value = this.get(key);
        Utils.require((value != null ? 1 : 0) != 0, (String)(String.valueOf(key) + " parameter is not set"));
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.valueOf(key) + " parameter should be a number");
        }
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.valueOf(key) + " parameter should be a number");
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return XType.getBoolean(value);
    }

    public void checkInvalidParameters() {
        for (String key : this.map.keySet()) {
            boolean wasRequested;
            boolean bl = wasRequested = this.requestedKeys != null && this.requestedKeys.contains(key);
            if (wasRequested) continue;
            throw new IllegalArgumentException("Unknown parameter " + key);
        }
    }
}

