/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.OlapAggregate;
import com.dell.doradus.olap.aggregate.AggregationResult;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.olap.OLAPService;
import com.dell.doradus.service.schema.SchemaService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Olapp {
    private Tenant m_tenant;
    private Olap m_olap;
    private Map<String, String> m_parameters;
    private StringBuilder m_builder;

    public int pcount() {
        return this.m_parameters.size();
    }

    public String getApplication() {
        return this.getParam("application");
    }

    public String getShard() {
        return this.getParam("shard");
    }

    public String getTable() {
        return this.getParam("table");
    }

    public String getQuery() {
        return this.getParam("query");
    }

    public String getField() {
        return this.getParam("field");
    }

    public String getLink() {
        return this.getParam("link");
    }

    private String getParam(String name) {
        String value = this.m_parameters.get(name);
        if ("null".equals(value)) {
            return null;
        }
        return value;
    }

    public Olapp(Tenant tenant, Olap olap, Map<String, String> parameters) {
        this.m_tenant = tenant;
        this.m_olap = olap;
        this.m_parameters = parameters;
        this.m_builder = new StringBuilder();
    }

    public static String process(Tenant tenant, Olap olap, Map<String, String> parameters) {
        Olapp olapp = new Olapp(tenant, olap, parameters);
        return olapp.process();
    }

    private String process() {
        if (this.pcount() == 0) {
            return this.processGetApplications();
        }
        return this.processAggregate();
    }

    private String processGetApplications() {
        List<ApplicationDefinition> appDefs = OLAPService.instance().getAllOLAPApplications(this.m_tenant);
        this.m_builder.append("<html><body><table border='1'>");
        this.addHeader("Applications", "Shards", "Tables");
        for (ApplicationDefinition appDef : appDefs) {
            String application = appDef.getAppName();
            this.addRow("<b>" + application + "</b>", "", "");
            for (String shard : this.m_olap.listShards(appDef)) {
                this.addRow("", "<b>" + shard + "</b>", "");
                for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
                    this.addRow("", "", String.format("<a href='?application=%s&shard=%s&table=%s&query=*'>%s</a>", application, shard, tableDef.getTableName(), tableDef.getTableName()));
                }
            }
        }
        this.m_builder.append("</table></body></html>");
        return this.m_builder.toString();
    }

    private String getAppPar() {
        return String.format("?application=%s&shard=%s&table=%s", this.getApplication(), this.getShard(), this.getTable());
    }

    private String processAggregate() {
        String[] query;
        this.m_builder.append("<html><body>");
        this.m_builder.append("<table border='0'>");
        this.addRow("<b>Filter</b>", String.format("<a href='%s&query=*&field=%s&link=%s'><i>clear</i></a>", this.getAppPar(), this.getField(), this.getLink()));
        String[] stringArray = query = this.getQuery().split("\\|");
        int n = query.length;
        int n2 = 0;
        while (n2 < n) {
            String qq = stringArray[n2];
            this.addRow(qq);
            ++n2;
        }
        this.m_builder.append("</table>\n\n");
        ApplicationDefinition appDef = SchemaService.instance().getApplication(this.m_tenant, this.getApplication());
        TableDefinition tableDef = appDef.getTableDef(this.getTable());
        if (this.getLink() == null) {
            this.m_builder.append("<b>Fields</b><br/>\n");
            int i = 0;
            for (FieldDefinition fieldDef : this.getFields(tableDef)) {
                if (!fieldDef.isScalarField()) continue;
                String fv = null;
                if (fieldDef.getType() == FieldType.INTEGER || fieldDef.getType() == FieldType.LONG) {
                    fv = fieldDef.getName();
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), fieldDef.getName()));
                    fv = "BATCH(" + fieldDef.getName() + ",0,1000,10000,100000,1000000)";
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), String.valueOf(fieldDef.getName()) + "<i>(batch)</i>"));
                    ++i;
                } else if (fieldDef.getType() == FieldType.TIMESTAMP) {
                    fv = "TRUNCATE(" + fieldDef.getName() + ",HOUR)";
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), String.valueOf(fieldDef.getName()) + "<i>(hour)</i>"));
                } else {
                    fv = fieldDef.getName();
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), fieldDef.getName()));
                }
                if (++i <= 7) continue;
                i = 0;
                this.m_builder.append("<br/>\n");
            }
            this.m_builder.append("<br/>\n");
            this.m_builder.append("<b>Links</b><br/>\n");
            i = 0;
            for (FieldDefinition fieldDef : this.getFields(tableDef)) {
                if (!fieldDef.isLinkField()) continue;
                this.m_builder.append(String.format("<a href='%s&query=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fieldDef.getName(), fieldDef.getName()));
                if (++i <= 7) continue;
                i = 0;
                this.m_builder.append("<br/>\n");
            }
            this.m_builder.append("<br/>\n");
        } else {
            this.m_builder.append("<b>Fields (");
            String[] strs = this.getLink().split("\\.");
            TableDefinition td = tableDef;
            String current = null;
            this.m_builder.append(String.format("<a href='%s&query=%s&field=%s'>%s</a>", this.getAppPar(), this.getQuery(), this.getField(), tableDef.getTableName()));
            String[] stringArray2 = strs;
            int n3 = strs.length;
            int n4 = 0;
            while (n4 < n3) {
                String str = stringArray2[n4];
                FieldDefinition link = td.getFieldDef(str);
                td = td.getAppDef().getTableDef(link.getLinkExtent());
                current = current == null ? str : String.valueOf(current) + "." + str;
                this.m_builder.append(".");
                this.m_builder.append(String.format("<a href='%s&query=%s&link=%s'>%s</a>", this.getAppPar(), this.getQuery(), current, str));
                ++n4;
            }
            this.m_builder.append(")</b>\n<br/>");
            int i = 0;
            for (FieldDefinition fieldDef : this.getFields(td)) {
                if (!fieldDef.isScalarField()) continue;
                String fv = null;
                if (fieldDef.getType() == FieldType.INTEGER || fieldDef.getType() == FieldType.LONG) {
                    fv = String.valueOf(this.getLink()) + "." + fieldDef.getName();
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), fieldDef.getName()));
                    fv = "BATCH(" + this.getLink() + "." + fieldDef.getName() + ",0,1000,10000,100000,1000000)";
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), String.valueOf(fieldDef.getName()) + "<i>(batch)</i>"));
                    ++i;
                } else if (fieldDef.getType() == FieldType.TIMESTAMP) {
                    fv = "TRUNCATE(" + this.getLink() + "." + fieldDef.getName() + ",HOUR)";
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), String.valueOf(fieldDef.getName()) + "<i>(hour)</i>"));
                } else {
                    fv = String.valueOf(this.getLink()) + "." + fieldDef.getName();
                    this.m_builder.append(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), fv, this.getLink(), fieldDef.getName()));
                }
                if (++i <= 7) continue;
                i = 0;
                this.m_builder.append("<br/>\n");
            }
            this.m_builder.append("<br/>\n");
            this.m_builder.append("<b>Links</b><br/>\n");
            i = 0;
            for (FieldDefinition fieldDef : this.getFields(td)) {
                if (!fieldDef.isLinkField()) continue;
                this.m_builder.append(String.format("<a href='%s&query=%s&link=%s.%s'>%s</a>&nbsp;&nbsp;&nbsp;&nbsp;", this.getAppPar(), this.getQuery(), this.getLink(), fieldDef.getName(), fieldDef.getName()));
                if (++i <= 7) continue;
                i = 0;
                this.m_builder.append("<br/>\n");
            }
            this.m_builder.append("<br/>\n");
        }
        AggregationResult r = this.m_olap.aggregate(appDef, this.getTable(), new OlapAggregate(this.getShard(), this.getQuery().replaceAll("\\|", " AND "), this.getField() == null ? null : "TOP(20," + this.getField() + ")", "COUNT(*)", null));
        this.m_builder.append("<br/>\n");
        this.m_builder.append("<table border='1'>");
        this.addHeader("Results", "" + r.documentsCount);
        for (AggregationResult.AggregationGroup gc : r.groups) {
            String fld = this.getField();
            String value = gc.name;
            if (value == null) continue;
            if (fld.startsWith("BATCH")) {
                fld = fld.split("\\(|\\,| ")[1];
                if (value.indexOf(45) > 0) {
                    value = value.replace("-", "TO");
                    fld = String.valueOf(fld) + "=[" + value + "]";
                } else {
                    fld = String.valueOf(fld) + value;
                }
            } else if (fld.startsWith("TRUNCATE")) {
                fld = fld.split("\\(|\\,| ")[1];
                fld = String.valueOf(fld) + "=[&quot;" + value + "&quot; TO &quot;" + value.substring(0, 14) + "59:59&quot;]";
            } else {
                fld = String.valueOf(fld) + "=&quot;" + value + "&quot;";
            }
            this.addRow(String.format("<a href='%s&query=%s&field=%s&link=%s'>%s</a>", this.getAppPar(), String.valueOf(this.getQuery()) + "|" + fld, this.getField(), this.getLink(), gc.name), gc.metricSet.values[0].toString());
        }
        this.m_builder.append("</table>\n");
        this.m_builder.append("</body></html>");
        return this.m_builder.toString();
    }

    private List<FieldDefinition> getFields(TableDefinition tableDef) {
        HashSet<FieldDefinition> fieldsSet = new HashSet<FieldDefinition>();
        for (FieldDefinition fieldDef : tableDef.getFieldDefinitions()) {
            this.addField(fieldDef, fieldsSet);
        }
        ArrayList<FieldDefinition> fields = new ArrayList<FieldDefinition>(fieldsSet);
        Collections.sort(fields, new Comparator<FieldDefinition>(){

            @Override
            public int compare(FieldDefinition x, FieldDefinition y) {
                return x.getName().compareTo(y.getName());
            }
        });
        return fields;
    }

    private void addField(FieldDefinition fieldDef, Set<FieldDefinition> fields) {
        if (fieldDef.getType() == FieldType.GROUP) {
            for (FieldDefinition child : fieldDef.getNestedFields()) {
                this.addField(child, fields);
            }
        } else {
            fields.add(fieldDef);
        }
    }

    private void addHeader(String ... values) {
        this.m_builder.append("<tr>");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.m_builder.append("<th>");
            this.m_builder.append(value);
            this.m_builder.append("</th>");
            ++n2;
        }
        this.m_builder.append("</tr>\n");
    }

    private void addRow(String ... values) {
        this.m_builder.append("<tr>");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.m_builder.append("<td>");
            this.m_builder.append(value);
            this.m_builder.append("</td>");
            ++n2;
        }
        this.m_builder.append("</tr>\n");
    }
}

