/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.UNode;
import com.dell.doradus.olap.io.FileInfo;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VInputStream;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.NumSearcherMV;
import com.dell.doradus.olap.store.SegmentStats;
import com.dell.doradus.olap.store.ValueSearcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class OlapStatistics {
    public static UNode getStatistics(CubeSearcher searcher, String sort, boolean memoryStats) {
        UNode unode = UNode.createMapNode((String)"statistics");
        UNode fnode = unode.addArrayNode("files");
        VDirectory dir = searcher.getDirectory();
        long total_cl = 0L;
        long total_ul = 0L;
        long total_files = 0L;
        long total_docs = 0L;
        long total_fields_count = 0L;
        ArrayList<FileInfo> files = new ArrayList<FileInfo>(dir.listFiles());
        for (FileInfo file : files) {
            if (file.getCompressedLength() != 0L) continue;
            file.setCompressedLength(dir.compressedLength(file));
        }
        if (sort == null || "name".equals(sort)) {
            Collections.sort(files);
        } else if ("cmp".equals(sort)) {
            Collections.sort(files, new Comparator<FileInfo>(){

                @Override
                public int compare(FileInfo x, FileInfo y) {
                    return Long.compare(x.getCompressedLength(), y.getCompressedLength());
                }
            });
        } else if ("unc".equals(sort)) {
            Collections.sort(files, new Comparator<FileInfo>(){

                @Override
                public int compare(FileInfo x, FileInfo y) {
                    return Long.compare(x.getLength(), y.getLength());
                }
            });
        }
        for (FileInfo file : files) {
            UNode fileNode = fnode.addMapNode("file");
            fileNode.addValueNode("name", file.getName(), true);
            long cl = file.getCompressedLength();
            long ul = file.getLength();
            fileNode.addValueNode("cmp", OlapStatistics.fmt(cl), true);
            fileNode.addValueNode("unc", OlapStatistics.fmt(ul), true);
            total_cl += cl;
            total_ul += ul;
            ++total_files;
        }
        fnode.addValueNode("files", OlapStatistics.fmt(total_files), true);
        fnode.addValueNode("cmp", OlapStatistics.fmt(total_cl), true);
        fnode.addValueNode("unc", OlapStatistics.fmt(total_ul), true);
        if (!memoryStats) {
            return unode;
        }
        SegmentStats stats = searcher.getStats();
        UNode tablesNode = unode.addArrayNode("tables");
        long total_memory = 0L;
        for (SegmentStats.Table table : stats.tables.values()) {
            long size;
            UNode tableNode = tablesNode.addMapNode("table");
            tableNode.addValueNode("name", table.name, true);
            tableNode.addValueNode("docs", OlapStatistics.fmt(table.documents), true);
            total_docs += (long)table.documents;
            long total_num_mem = 0L;
            long total_fld_mem = 0L;
            long total_val_mem = 0L;
            long total_lnk_mem = 0L;
            long total_nums = 0L;
            long total_flds = 0L;
            long total_lnks = 0L;
            UNode idsNode = tableNode.addMapNode("id-field");
            IdSearcher ids = searcher.getIdSearcher(table.name);
            long total_ids_mem = ids.cacheSize();
            idsNode.addValueNode("ids_mem", OlapStatistics.fmt(total_ids_mem), true);
            UNode numsNode = tableNode.addArrayNode("num-fields");
            for (SegmentStats.Table.NumField numField : table.numFields.values()) {
                UNode numNode = numsNode.addMapNode("num");
                NumSearcherMV num = searcher.getNumSearcher(table.name, numField.name);
                long size2 = num.cacheSize();
                total_num_mem += size2;
                numNode.addValueNode("name", numField.name, true);
                numNode.addValueNode("mem", OlapStatistics.fmt(size2), true);
                ++total_nums;
            }
            numsNode.addValueNode("flds", OlapStatistics.fmt(total_nums), true);
            numsNode.addValueNode("num_mem", OlapStatistics.fmt(total_num_mem), true);
            UNode fldsNode = tableNode.addArrayNode("txt-fields");
            UNode valsNode = tableNode.addArrayNode("val-fields");
            for (SegmentStats.Table.TextField txtField : table.textFields.values()) {
                UNode fldNode = fldsNode.addMapNode("fld");
                UNode valNode = valsNode.addMapNode("val");
                FieldSearcher fld = searcher.getFieldSearcher(table.name, txtField.name);
                size = fld.cacheSize();
                total_fld_mem += size;
                fldNode.addValueNode("name", txtField.name, true);
                fldNode.addValueNode("mem", OlapStatistics.fmt(size), true);
                ValueSearcher val = searcher.getValueSearcher(table.name, txtField.name);
                size = val.cacheSize();
                total_val_mem += size;
                valNode.addValueNode("name", txtField.name, true);
                valNode.addValueNode("mem", OlapStatistics.fmt(size), true);
                ++total_flds;
            }
            fldsNode.addValueNode("cnt", OlapStatistics.fmt(total_flds), true);
            fldsNode.addValueNode("fld_mem", OlapStatistics.fmt(total_fld_mem), true);
            valsNode.addValueNode("flds", OlapStatistics.fmt(total_flds), true);
            valsNode.addValueNode("val_mem", OlapStatistics.fmt(total_val_mem), true);
            UNode lnksNode = tableNode.addArrayNode("lnk-fields");
            for (SegmentStats.Table.LinkField lnkField : table.linkFields.values()) {
                UNode lnkNode = lnksNode.addMapNode("lnk");
                FieldSearcher lnk = searcher.getFieldSearcher(table.name, lnkField.name);
                size = lnk.cacheSize();
                total_lnk_mem += size;
                lnkNode.addValueNode("name", lnkField.name, true);
                lnkNode.addValueNode("mem", OlapStatistics.fmt(size), true);
                ++total_lnks;
            }
            lnksNode.addValueNode("flds", OlapStatistics.fmt(total_lnks), true);
            lnksNode.addValueNode("lnk_mem", OlapStatistics.fmt(total_lnk_mem), true);
            long total_mem = total_ids_mem + total_num_mem + total_fld_mem + total_lnk_mem + total_val_mem;
            long total_cnt = total_nums + total_flds + total_lnks;
            total_fields_count += total_cnt;
            tableNode.addValueNode("flds", OlapStatistics.fmt(total_cnt), true);
            tableNode.addValueNode("mem", OlapStatistics.fmt(total_mem), true);
            total_memory += total_mem;
        }
        tablesNode.addValueNode("docs", OlapStatistics.fmt(total_docs), true);
        tablesNode.addValueNode("memory", OlapStatistics.fmt(total_memory), true);
        tablesNode.addValueNode("fields", OlapStatistics.fmt(total_fields_count), true);
        return unode;
    }

    public static UNode getFileData(CubeSearcher searcher, String file) {
        int length;
        byte[] buffer;
        UNode unode = UNode.createMapNode((String)"file");
        VDirectory dir = searcher.getDirectory();
        VInputStream strm = dir.open(file);
        int len = strm.read(buffer = new byte[length = (int)Math.min(16384L, strm.length())], 0, buffer.length);
        if (len != length) {
            throw new RuntimeException("Failed to read file data");
        }
        StringBuilder sb1 = new StringBuilder(3 * len);
        StringBuilder sb2 = new StringBuilder(3 * len);
        int i = 0;
        while (i < len) {
            byte b = buffer[i];
            sb1.append(String.format("%d ", b));
            if (b < 32) {
                sb2.append('-');
            } else {
                sb2.append((char)b);
            }
            ++i;
        }
        unode.addValueNode("data", sb1.toString(), false);
        unode.addValueNode("txt", sb2.toString(), false);
        return unode;
    }

    private static String fmt(long val) {
        return String.format("%,8d", val).trim();
    }
}

