/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.ParsedQuery;
import java.util.List;

public class OlapQuery {
    private String m_query;
    private int m_pageSize = -1;
    private int m_skip = 0;
    private String m_fields;
    private String m_sortOrder;
    private String m_shards;
    private String m_shardsRange;
    private String m_pair;
    private String m_xshards;
    private String m_xshardsRange;
    private String m_continueAt;
    private String m_continueAfter;
    private String m_metrics;
    private String m_originalQuery;

    public OlapQuery(UNode searchNode) {
        assert (searchNode != null);
        ParsedQuery parsedQuery = new ParsedQuery("search", searchNode);
        this.m_query = parsedQuery.get("query");
        this.m_pageSize = parsedQuery.getInt("size", -1);
        this.m_skip = parsedQuery.getInt("skip", 0);
        this.m_fields = parsedQuery.get("fields");
        this.m_sortOrder = parsedQuery.get("order");
        this.m_shards = parsedQuery.get("shards");
        this.m_shardsRange = parsedQuery.get("shards-range");
        this.m_pair = parsedQuery.get("pair");
        this.m_xshards = parsedQuery.get("x-shards");
        this.m_xshardsRange = parsedQuery.get("x-shards-range");
        this.m_continueAt = parsedQuery.get("continue-at");
        this.m_continueAfter = parsedQuery.get("continue-after");
        this.m_metrics = parsedQuery.get("metric");
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public OlapQuery(String queryParam) throws IllegalArgumentException {
        assert (queryParam != null);
        ParsedQuery parsedQuery = new ParsedQuery(queryParam);
        this.m_query = parsedQuery.get("q");
        this.m_pageSize = parsedQuery.getInt("s", -1);
        this.m_skip = parsedQuery.getInt("k", 0);
        this.m_fields = parsedQuery.get("f");
        this.m_sortOrder = parsedQuery.get("o");
        this.m_shards = parsedQuery.get("shards");
        this.m_shardsRange = parsedQuery.get("range");
        this.m_pair = parsedQuery.get("pair");
        this.m_xshards = parsedQuery.get("xshards");
        this.m_xshardsRange = parsedQuery.get("xrange");
        this.m_continueAt = parsedQuery.get("e");
        this.m_continueAfter = parsedQuery.get("g");
        this.m_metrics = parsedQuery.get("m");
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public OlapQuery(String shards, String query) {
        this.m_shards = shards;
        this.m_query = query;
        this.checkDefaults();
    }

    public void fixPairParameter() {
        if (this.m_pair == null) {
            return;
        }
        if (this.m_query == null) {
            return;
        }
        if (!this.m_query.contains("_pair.")) {
            return;
        }
        this.m_originalQuery = this.m_query;
        String[] pairs = Utils.split((String)this.m_pair, (char)',').toArray(new String[2]);
        if (pairs.length != 2) {
            throw new IllegalArgumentException("pair must contain two fields");
        }
        pairs[0] = pairs[0].trim();
        pairs[1] = pairs[1].trim();
        String first = this.m_query.replace("_pair.first", pairs[0]).replace("_pair.second", pairs[1]);
        String second = this.m_query.replace("_pair.first", pairs[1]).replace("_pair.second", pairs[0]);
        this.m_query = "(" + first + ") OR (" + second + ")";
    }

    public String getFieldSet() {
        return this.m_fields;
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    public int getSkip() {
        return this.m_skip;
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getSortOrder() {
        return this.m_sortOrder;
    }

    public String getContinueAt() {
        return this.m_continueAt;
    }

    public String getContinueAfter() {
        return this.m_continueAfter;
    }

    public String getMetrics() {
        return this.m_metrics;
    }

    public String getShards() {
        return this.m_shards;
    }

    public String getShardsRange() {
        return this.m_shardsRange;
    }

    public String getXShards() {
        return this.m_xshards;
    }

    public String getXShardsRange() {
        return this.m_xshardsRange;
    }

    public String getPair() {
        return this.m_pair;
    }

    public String getOriginalQuery() {
        return this.m_originalQuery == null ? this.m_query : this.m_originalQuery;
    }

    public List<String> getShards(ApplicationDefinition appDef, Olap olap) {
        return olap.getShardsList(appDef, this.m_shards, this.m_shardsRange);
    }

    public List<String> getXShards(ApplicationDefinition appDef, Olap olap) {
        return olap.getShardsList(appDef, this.m_xshards, this.m_xshardsRange);
    }

    public int getPageSizeWithSkip() {
        if (this.m_pageSize < 0) {
            return this.m_skip + ServerConfig.getInstance().search_default_page_size;
        }
        if (this.m_pageSize == 0) {
            return Integer.MAX_VALUE;
        }
        return this.m_pageSize + this.m_skip;
    }

    private void checkDefaults() {
        Utils.require((this.m_shards != null || this.m_shardsRange != null ? 1 : 0) != 0, (String)"shards or range parameter is not set");
        Utils.require((this.m_shards == null || this.m_shardsRange == null ? 1 : 0) != 0, (String)"shards and range parameters cannot be both set");
        Utils.require((this.m_continueAt == null || this.m_continueAfter == null ? 1 : 0) != 0, (String)"Both continue-at and continue-after parameters cannot be set");
        Utils.require((this.m_continueAt == null && this.m_continueAfter == null || this.m_sortOrder == null ? 1 : 0) != 0, (String)"continuation oarameters cannot be set if sort order is set");
        Utils.require((this.m_xshards == null || this.m_xshardsRange == null ? 1 : 0) != 0, (String)"xshards and xrange parameters cannot be both set");
        if (this.m_xshards == null && this.m_xshardsRange == null) {
            this.m_xshards = this.m_shards;
            this.m_xshardsRange = this.m_shardsRange;
        }
        if (this.m_query == null) {
            this.m_query = "*";
        }
        if (this.m_pageSize == -1) {
            this.m_pageSize = ServerConfig.getInstance().search_default_page_size;
        }
    }
}

