/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.IDGenerator;
import com.dell.doradus.olap.OlapDocument;
import com.dell.doradus.olap.builder.BatchBuilder;
import com.dell.doradus.olap.builder.SegmentBuilder;
import com.dell.doradus.olap.collections.strings.StringList;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.store.IntList;
import java.io.Reader;
import java.util.Iterator;

public class OlapBatch
implements Iterable<OlapDocument> {
    private StringList m_data = new StringList();
    private IntList m_deleted = new IntList(64);
    private IntList m_docOffsets = new IntList(64);

    public static OlapBatch parseJSON(String text) {
        return BatchBuilder.parseJSON(text);
    }

    public static OlapBatch parseJSON(Reader reader) {
        return BatchBuilder.parseJSON(reader);
    }

    public static OlapBatch fromUNode(UNode rootNode) {
        return BatchBuilder.fromUNode(rootNode);
    }

    public OlapDocument addDoc() {
        return this.addDoc(null, null);
    }

    public OlapDocument addDoc(String table, String id) {
        if (id == null) {
            id = Utils.base64FromBinary((byte[])IDGenerator.nextID());
        }
        this.m_docOffsets.add(this.m_data.size());
        this.m_data.add(table);
        this.m_data.add(id);
        this.m_deleted.add(0);
        return new OlapDocument(new InternalOlapDocument2(this.size() - 1));
    }

    public void clear() {
        this.m_data.clear();
        this.m_deleted.clear();
        this.m_docOffsets.clear();
    }

    public int size() {
        return this.m_docOffsets.size();
    }

    public OlapDocument get(int index) {
        return new OlapDocument(new InternalOlapDocument2(index));
    }

    @Override
    public Iterator<OlapDocument> iterator() {
        return new DocIterator();
    }

    public void flushSegment(ApplicationDefinition application, VDirectory directory) {
        SegmentBuilder builder = new SegmentBuilder(application);
        builder.add(this);
        builder.flush(directory);
    }

    public class DocIterator
    implements Iterator<OlapDocument> {
        private int m_next;

        @Override
        public boolean hasNext() {
            return this.m_next < OlapBatch.this.size();
        }

        @Override
        public OlapDocument next() {
            return OlapBatch.this.get(this.m_next++);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not Implemented");
        }
    }

    class InternalOlapDocument2 {
        private int m_index;
        private int m_offset;

        InternalOlapDocument2(int index) {
            this.setIndex(index);
        }

        public void addField(String field, String value) {
            if (this.m_index < OlapBatch.this.size() - 1) {
                throw new RuntimeException("Fields can be added only to the last added document");
            }
            if (value == null) {
                return;
            }
            OlapBatch.this.m_data.add(field);
            OlapBatch.this.m_data.add(value);
        }

        private int data(int field) {
            return this.m_offset + field * 2;
        }

        public String getTable() {
            return OlapBatch.this.m_data.get(this.data(0));
        }

        public String getId() {
            return OlapBatch.this.m_data.get(this.data(0) + 1);
        }

        public void setTable(String table) {
            OlapBatch.this.m_data.set(this.data(0), table);
        }

        public void setId(String id) {
            OlapBatch.this.m_data.set(this.data(0) + 1, id);
        }

        public boolean isDeleted() {
            return OlapBatch.this.m_deleted == null ? false : OlapBatch.this.m_deleted.get(this.m_index) == 1;
        }

        public int getFieldsCount() {
            if (this.m_index == OlapBatch.this.size() - 1) {
                return (OlapBatch.this.m_data.size() - OlapBatch.this.m_docOffsets.get(this.m_index) - 2) / 2;
            }
            return (OlapBatch.this.m_docOffsets.get(this.m_index + 1) - OlapBatch.this.m_docOffsets.get(this.m_index) - 2) / 2;
        }

        public String getFieldName(int field) {
            return OlapBatch.this.m_data.get(this.data(field + 1));
        }

        public String getFieldValue(int field) {
            return OlapBatch.this.m_data.get(this.data(field + 1) + 1);
        }

        public BSTR getIdBinary() {
            return OlapBatch.this.m_data.getBinary(this.data(0) + 1);
        }

        public BSTR getFieldNameBinary(int field) {
            return OlapBatch.this.m_data.getBinary(this.data(field + 1));
        }

        public BSTR getFieldValueBinary(int field) {
            return OlapBatch.this.m_data.getBinary(this.data(field + 1) + 1);
        }

        public BSTR getFieldValueBinaryLowercase(int field) {
            return OlapBatch.this.m_data.getBinaryLowercase(this.data(field + 1) + 1);
        }

        public void setDeleted(boolean deleted) {
            OlapBatch.this.m_deleted.set(this.m_index, deleted ? 1 : 0);
        }

        public void setIndex(int index) {
            this.m_index = index;
            this.m_offset = OlapBatch.this.m_docOffsets.get(this.m_index);
        }
    }
}

