/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.ParsedQuery;
import com.dell.doradus.olap.aggregate.AggregationRequestData;

public class OlapAggregate {
    private String m_query;
    private String m_fields;
    private String m_metrics;
    private String m_shards;
    private String m_shardsRange;
    private String m_pair;
    private String m_xshards;
    private String m_xshardsRange;
    private boolean m_flat;

    public OlapAggregate(UNode searchNode) {
        assert (searchNode != null);
        ParsedQuery parsedQuery = new ParsedQuery("aggregate-search", searchNode);
        this.m_query = parsedQuery.get("query");
        this.m_fields = parsedQuery.get("grouping-fields");
        Utils.require((parsedQuery.get("composite-fields") == null ? 1 : 0) != 0, (String)"OLAP queries cannot use composite grouping composite-fields parameter");
        this.m_metrics = parsedQuery.get("metric");
        this.m_shards = parsedQuery.get("shards");
        this.m_shardsRange = parsedQuery.get("shards-range");
        this.m_pair = parsedQuery.get("pair");
        this.m_xshards = parsedQuery.get("x-shards");
        this.m_xshardsRange = parsedQuery.get("x-shards-range");
        this.m_flat = parsedQuery.getBoolean("flat", false);
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public OlapAggregate(String queryParam) throws IllegalArgumentException {
        assert (queryParam != null);
        ParsedQuery parsedQuery = new ParsedQuery(queryParam);
        this.m_query = parsedQuery.get("q");
        this.m_fields = parsedQuery.get("f");
        Utils.require((parsedQuery.get("cf") == null ? 1 : 0) != 0, (String)"OLAP queries cannot use composite grouping composite-fields parameter");
        this.m_metrics = parsedQuery.get("m");
        this.m_shards = parsedQuery.get("shards");
        this.m_shardsRange = parsedQuery.get("range");
        this.m_pair = parsedQuery.get("pair");
        this.m_xshards = parsedQuery.get("xshards");
        this.m_xshardsRange = parsedQuery.get("xrange");
        this.m_flat = parsedQuery.getBoolean("flat", false);
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public OlapAggregate(String shards, String query, String fields, String metrics, String pair) {
        this.m_shards = shards;
        this.m_query = query;
        this.m_fields = fields;
        this.m_metrics = metrics;
        this.m_pair = pair;
        this.checkDefaults();
    }

    public void setShards(String shards, String shardsRange) {
        this.m_shards = shards;
        this.m_shardsRange = shardsRange;
    }

    public void setXShards(String xshards, String xshardsRange) {
        this.m_xshards = xshards;
        this.m_xshardsRange = xshardsRange;
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getFields() {
        return this.m_fields;
    }

    public String getMetrics() {
        return this.m_metrics;
    }

    public AggregationRequestData createRequestData(Olap olap, ApplicationDefinition appDef, String table) {
        AggregationRequestData requestData = new AggregationRequestData();
        requestData.application = appDef.getAppName();
        requestData.shards = olap.getShardsList(appDef, this.m_shards, this.m_shardsRange);
        requestData.xshards = olap.getShardsList(appDef, this.m_xshards, this.m_xshardsRange);
        requestData.table = table;
        requestData.flat = this.m_flat;
        if (this.m_pair == null) {
            requestData.parts = new AggregationRequestData.Part[1];
            requestData.parts[0] = new AggregationRequestData.Part();
            requestData.parts[0].query = this.m_query;
            requestData.parts[0].field = this.m_fields;
            requestData.parts[0].metrics = this.m_metrics;
            return requestData;
        }
        String[] pairs = Utils.split((String)this.m_pair, (char)',').toArray(new String[0]);
        Utils.require((pairs.length == 2 ? 1 : 0) != 0, (String)"_pair must contain two fields");
        pairs[0] = pairs[0].trim();
        pairs[1] = pairs[1].trim();
        requestData.parts = new AggregationRequestData.Part[2];
        requestData.parts[0] = new AggregationRequestData.Part();
        requestData.parts[1] = new AggregationRequestData.Part();
        if (this.m_query != null) {
            requestData.parts[0].query = this.m_query.replace("_pair.first", pairs[0]).replace("_pair.second", pairs[1]);
            requestData.parts[1].query = this.m_query.replace("_pair.first", pairs[1]).replace("_pair.second", pairs[0]);
        }
        if (this.m_fields != null) {
            requestData.parts[0].field = this.m_fields.replace("_pair.first", pairs[0]).replace("_pair.second", pairs[1]);
            requestData.parts[1].field = this.m_fields.replace("_pair.first", pairs[1]).replace("_pair.second", pairs[0]);
        }
        if (this.m_metrics != null) {
            requestData.differentMetricsForPairs = this.m_metrics.contains("_pair.first") || this.m_metrics.contains("_pair.second");
            requestData.parts[0].metrics = this.m_metrics.replace("_pair.first", pairs[0]).replace("_pair.second", pairs[1]);
            requestData.parts[1].metrics = this.m_metrics.replace("_pair.first", pairs[1]).replace("_pair.second", pairs[0]);
        }
        return requestData;
    }

    private void checkDefaults() {
        Utils.require((this.m_shards != null || this.m_shardsRange != null ? 1 : 0) != 0, (String)"shards or range parameter is not set");
        Utils.require((this.m_shards == null || this.m_shardsRange == null ? 1 : 0) != 0, (String)"shards and range parameters cannot be both set");
        Utils.require((this.m_xshards == null || this.m_xshardsRange == null ? 1 : 0) != 0, (String)"xshards and xrange parameters cannot be both set");
        if (this.m_xshards == null && this.m_xshardsRange == null) {
            this.m_xshards = this.m_shards;
            this.m_xshardsRange = this.m_shardsRange;
        }
        if (this.m_query == null) {
            this.m_query = "*";
        }
        if (this.m_metrics == null) {
            this.m_metrics = "COUNT(*)";
        }
    }
}

