/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.olap.FieldsCache;
import com.dell.doradus.olap.MergeOptions;
import com.dell.doradus.olap.OlapAggregate;
import com.dell.doradus.olap.OlapBatch;
import com.dell.doradus.olap.OlapQuery;
import com.dell.doradus.olap.XType;
import com.dell.doradus.olap.aggregate.AggregationRequest;
import com.dell.doradus.olap.aggregate.AggregationRequestData;
import com.dell.doradus.olap.aggregate.AggregationResult;
import com.dell.doradus.olap.aggregate.DuplicationDetection;
import com.dell.doradus.olap.aggregate.mr.MFAggregationBuilder;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.merge.Merger;
import com.dell.doradus.olap.search.Searcher;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.SegmentStats;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.util.LRUCache;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.tenant.TenantService;
import com.dell.doradus.utilities.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Olap {
    private static Logger LOG = LoggerFactory.getLogger((String)"Olap.Olap");
    private static ExecutorService search_executor = ServerConfig.getInstance().olap_search_threads == 0 ? null : Executors.newFixedThreadPool(ServerConfig.getInstance().olap_search_threads);
    private Map<String, Map<String, VDirectory>> m_tenantAppRoots = new HashMap<String, Map<String, VDirectory>>();
    private FieldsCache m_fieldsCache;
    private LRUCache<String, CubeSearcher> m_cachedSearchers;
    private Set<String> m_mergedCubes;

    public Olap() {
        this.m_fieldsCache = new FieldsCache((long)ServerConfig.getInstance().olap_cache_size_mb * 1024L * 1024L);
        this.m_cachedSearchers = new LRUCache(Math.min(8192, ServerConfig.getInstance().olap_loaded_segments));
        this.m_mergedCubes = new HashSet<String>();
    }

    public static ExecutorService getSearchThreadPool() {
        return search_executor;
    }

    public VDirectory createApplication(String appName) {
        String keyspace = ServerConfig.getInstance().keyspace;
        Tenant tenant = new Tenant(keyspace);
        return this.createApplication(tenant, appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VDirectory createApplication(Tenant tenant, String appName) {
        DBService.instance().createStoreIfAbsent(tenant, "OLAP", true);
        VDirectory root = new VDirectory(tenant, "OLAP").getDirectoryCreate("applications").getDirectoryCreate(appName);
        Map<String, Map<String, VDirectory>> map = this.m_tenantAppRoots;
        synchronized (map) {
            String tenantName = tenant.getKeyspace();
            Map<String, VDirectory> appRoots = this.m_tenantAppRoots.get(tenantName);
            if (appRoots == null) {
                appRoots = new HashMap<String, VDirectory>();
                this.m_tenantAppRoots.put(tenantName, appRoots);
            }
            appRoots.put(appName, root);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VDirectory getRoot(ApplicationDefinition appDef) {
        VDirectory root = null;
        Tenant tenant = Tenant.getTenant(appDef);
        Map<String, Map<String, VDirectory>> map = this.m_tenantAppRoots;
        synchronized (map) {
            Map<String, VDirectory> appRoots = this.m_tenantAppRoots.get(tenant.getKeyspace());
            if (appRoots == null) {
                appRoots = new HashMap<String, VDirectory>();
                this.m_tenantAppRoots.put(tenant.getKeyspace(), appRoots);
            }
            if ((root = appRoots.get(appDef.getAppName())) == null) {
                root = new VDirectory(tenant, "OLAP").getDirectory("applications").getDirectory(appDef.getAppName());
                assert (root != null);
                appRoots.put(appDef.getAppName(), root);
            }
        }
        return root;
    }

    public VDirectory getDirectory(ApplicationDefinition appDef, String shard) {
        VDirectory appDir = this.getRoot(appDef);
        VDirectory shardDir = appDir.getDirectory(shard);
        String segment = this.getCubeSegment(appDef, shard);
        VDirectory segmentDir = shardDir.getDirectory(segment);
        return segmentDir;
    }

    public ApplicationDefinition getApplicationDefinition(Tenant tenant, String applicationName) {
        if (tenant == null) {
            tenant = TenantService.instance().getDefaultTenant();
        }
        ApplicationDefinition appDef = SchemaService.instance().getApplication(tenant, applicationName);
        return appDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteApplication(ApplicationDefinition appDef) {
        VDirectory root = this.getRoot(appDef);
        Map<String, Map<String, VDirectory>> map = this.m_tenantAppRoots;
        synchronized (map) {
            root.delete();
            String tenantName = Tenant.getTenant(appDef).getKeyspace();
            Map<String, VDirectory> appRoots = this.m_tenantAppRoots.get(tenantName);
            if (appRoots != null) {
                appRoots.remove(appDef.getAppName());
            }
        }
    }

    public void deleteShard(ApplicationDefinition appDef, String shard) {
        this.getRoot(appDef).getDirectory(shard).delete();
    }

    public List<String> listShards(ApplicationDefinition appDef) {
        return this.getRoot(appDef).listDirectories();
    }

    public List<String> listSegments(ApplicationDefinition appDef, String shard) {
        VDirectory shardDir = this.getRoot(appDef).getDirectory(shard);
        return shardDir.listDirectories();
    }

    public String getCubeSegment(ApplicationDefinition appDef, String shard) {
        VDirectory shardDir = this.getRoot(appDef).getDirectory(shard);
        return shardDir.getProperty(".cube.txt");
    }

    public SegmentStats getStats(ApplicationDefinition appDef, String shard) {
        String cube = this.getCubeSegment(appDef, shard);
        if (cube == null) {
            throw new IllegalArgumentException("Application does not exist or does not have merges yet");
        }
        CubeSearcher s = this.getSearcher(appDef, shard, cube);
        return s.getStats();
    }

    public String addSegment(ApplicationDefinition appDef, String shard, OlapBatch batch) {
        return this.addSegment(appDef, shard, batch, true);
    }

    public String addSegment(ApplicationDefinition appDef, String shard, OlapBatch batch, boolean overwrite) {
        Timer t = new Timer();
        VDirectory shardDir = this.getRoot(appDef).getDirectoryCreate(shard);
        String prefix = overwrite ? "" : ".before.";
        String guid = prefix + Long.toString(System.currentTimeMillis(), 32) + "-" + UUID.randomUUID().toString();
        VDirectory segmentDir = shardDir.getDirectory(guid);
        batch.flushSegment(appDef, segmentDir);
        segmentDir.create();
        LOG.debug("add {} objects to {}/{} in {}", new Object[]{batch.size(), appDef.getAppName(), shard, t});
        return guid;
    }

    public AggregationResult aggregate(ApplicationDefinition appDef, String table, OlapAggregate olapAggregate) {
        AggregationRequestData requestData = olapAggregate.createRequestData(this, appDef, table);
        AggregationRequest aggregationRequest = new AggregationRequest(this, appDef, requestData);
        AggregationResult result = MFAggregationBuilder.aggregate(this, appDef, aggregationRequest);
        return result;
    }

    public SearchResultList search(ApplicationDefinition appDef, String table, OlapQuery olapQuery) {
        return Searcher.search(this, appDef, table, olapQuery);
    }

    public void merge(ApplicationDefinition appDef, String shard) {
        MergeOptions options = new MergeOptions(null, 0, true);
        this.merge(appDef, shard, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ApplicationDefinition appDef, String shard, MergeOptions options) {
        if (options == null) {
            options = new MergeOptions();
        }
        String key = appDef.getAppName() + "/" + shard;
        Set<String> set = this.m_mergedCubes;
        synchronized (set) {
            if (this.m_mergedCubes.contains(key)) {
                throw new IllegalArgumentException(key + " is being merged");
            }
            this.m_mergedCubes.add(key);
        }
        try {
            Timer t = new Timer();
            VDirectory shardDir = this.getRoot(appDef).getDirectory(shard);
            if (options.getExpireDate() != null) {
                shardDir.putProperty("expiration.txt", XType.toString(options.getExpireDate()));
            } else {
                shardDir.putProperty("expiration.txt", "");
            }
            List<String> segments = shardDir.listDirectories();
            if (segments.size() == 0) {
                LOG.debug("No segments in {}/{}", (Object)appDef.getAppName(), (Object)shard);
                return;
            }
            if (segments.size() == 1 && segments.get(0).startsWith(".cube.") && !options.getForceMerge()) {
                LOG.debug("Shard {}/{} was not modified", (Object)appDef.getAppName(), (Object)shard);
                return;
            }
            ArrayList<VDirectory> sources = new ArrayList<VDirectory>();
            for (String segment : segments) {
                sources.add(shardDir.getDirectory(segment));
            }
            String guid = ".cube." + UUID.randomUUID().toString();
            VDirectory destination = shardDir.getDirectory(guid);
            Merger.mergeApplication(appDef, sources, destination);
            shardDir.putProperty(".cube.txt", guid);
            destination.create();
            LOG.debug("finished merging {} segments to {}/{} in {}", new Object[]{segments.size(), appDef.getAppName(), shard, t});
            if (options.getTimeout() > 0) {
                try {
                    Thread.sleep(options.getTimeout() * 1000);
                }
                catch (InterruptedException e) {
                    LOG.warn("sleep interrupted", (Throwable)e);
                }
            }
            for (String segment : segments) {
                shardDir.getDirectory(segment).delete();
            }
            LOG.debug("merge {} segments to {}/{} in {}", new Object[]{segments.size(), appDef.getAppName(), shard, t});
        }
        finally {
            Set<String> set2 = this.m_mergedCubes;
            synchronized (set2) {
                this.m_mergedCubes.remove(key);
            }
        }
    }

    public Date getExpirationDate(ApplicationDefinition appDef, String shard) {
        VDirectory shardDir = this.getRoot(appDef).getDirectory(shard);
        String expDateStr = shardDir.getProperty("expiration.txt");
        if (expDateStr == null || expDateStr.length() == 0) {
            return null;
        }
        return Utils.dateFromString((String)expDateStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CubeSearcher getSearcher(ApplicationDefinition appDef, String shard, String segment) {
        LRUCache<String, CubeSearcher> lRUCache = this.m_cachedSearchers;
        synchronized (lRUCache) {
            String key = appDef.getAppName() + "/" + shard + "/" + segment;
            CubeSearcher s = (CubeSearcher)this.m_cachedSearchers.get(key);
            if (s == null) {
                VDirectory dir = this.getRoot(appDef);
                dir = dir.getDirectory(shard);
                dir = dir.getDirectory(segment);
                s = new CubeSearcher(dir, this.m_fieldsCache);
                this.m_cachedSearchers.put(key, s);
            }
            return s;
        }
    }

    public SearchResultList getDuplicateIDs(ApplicationDefinition appDef, String table, String shardsRange) {
        String application = appDef.getAppName();
        TableDefinition tableDef = appDef.getTableDef(table);
        if (tableDef == null) {
            throw new IllegalArgumentException("Table " + table + " not found in " + application);
        }
        List<String> shards = this.getShardsList(appDef, null, shardsRange);
        SearchResultList result = DuplicationDetection.getDuplicateIDs(tableDef, shards);
        return result;
    }

    public CubeSearcher getSearcher(ApplicationDefinition appDef, String shard) {
        String segment = this.getCubeSegment(appDef, shard);
        return this.getSearcher(appDef, shard, segment);
    }

    public List<String> getShardsList(ApplicationDefinition appDef, String shards, String shardsRange) {
        if (shards != null && shardsRange != null) {
            throw new IllegalArgumentException("Both shards and range parameters cannot be set");
        }
        if (shards == null && shardsRange == null) {
            throw new IllegalArgumentException("shards or range parameter not set");
        }
        List<String> shardsList = new ArrayList<String>();
        if (shards != null) {
            shardsList = Utils.split((String)shards, (char)',');
        } else if (shardsRange != null) {
            String[] range = Utils.split((String)shardsRange, (char)',').toArray(new String[0]);
            if (range.length == 0 || range.length > 2) {
                throw new IllegalArgumentException("Shards range must be in form start-shard,end-shard or start-shard");
            }
            List<String> allShards = this.listShards(appDef);
            String startShard = range[0];
            String endShard = range.length == 1 ? null : range[1];
            for (String shard : allShards) {
                if (shard.compareToIgnoreCase(startShard) < 0 || endShard != null && shard.compareToIgnoreCase(endShard) > 0) continue;
                shardsList.add(shard);
            }
        }
        return shardsList;
    }
}

