/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap;

import com.dell.doradus.common.UNode;
import com.dell.doradus.olap.ParsedQuery;
import java.util.Date;

public class MergeOptions {
    private Date m_expireDate = null;
    private int m_timeout = 0;
    private boolean m_forceMerge = false;

    public Date getExpireDate() {
        return this.m_expireDate;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public boolean getForceMerge() {
        return this.m_forceMerge;
    }

    public MergeOptions() {
    }

    public MergeOptions(Date expireDate, int timeout, boolean forceMerge) {
        this.m_expireDate = expireDate;
        this.m_timeout = timeout;
        this.m_forceMerge = forceMerge;
    }

    public MergeOptions(UNode node) {
        assert (node != null);
        ParsedQuery parsedQuery = new ParsedQuery("merge", node);
        this.m_expireDate = parsedQuery.getDate("expire-date");
        this.m_timeout = parsedQuery.getInt("timeout", 0);
        this.m_forceMerge = parsedQuery.getBoolean("force-merge", false);
    }

    public MergeOptions(String queryParam) throws IllegalArgumentException {
        assert (queryParam != null);
        ParsedQuery parsedQuery = new ParsedQuery(queryParam);
        this.m_expireDate = parsedQuery.getDate("expire-date");
        this.m_timeout = parsedQuery.getInt("timeout", 0);
        this.m_forceMerge = parsedQuery.getBoolean("force-merge", false);
    }
}

