/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.mbeans;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.management.LongJob;
import com.dell.doradus.management.StorageManagerMXBean;
import com.dell.doradus.mbeans.CassandraNode;
import com.dell.doradus.mbeans.MBeanBase;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManager
extends MBeanBase
implements StorageManagerMXBean {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    static int JOB_LIST_MAX_SIZE = 100;
    private static int jobCount;
    private CassandraNode node;
    private LongJob recentJob;
    private ExecutorService executor;
    private Future<?> future;
    private String pid;
    private Map<String, LongJob> jobMap = new HashMap<String, LongJob>();
    private List<String> jobList = new LinkedList<String>();

    public StorageManager(boolean publish) {
        this.domain = "com.dell.doradus";
        this.type = "StorageManager";
        if (publish) {
            this.register();
        }
    }

    public synchronized boolean awaitJobTermination(long timeoutInSeconds) throws InterruptedException {
        if (this.future != null && !this.future.isDone()) {
            this.logger.info("Blocking until active job completed (timeout: " + timeoutInSeconds + " secs).");
            return this.executor.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS);
        }
        return true;
    }

    public String getOperationMode() {
        String mode = this.getNode().getOperationMode();
        if (mode != null && "NORMAL".equals(mode.toUpperCase())) {
            mode = "NORMAL";
        }
        return mode;
    }

    public String getReleaseVersion() {
        return this.getNode().getReleaseVersion();
    }

    public String getOS() {
        return this.getNode().getOS();
    }

    public int getStartMode() {
        try {
            return this.getNode().isInForeground() ? 1 : 2;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public LongJob getRecentJob() {
        return this.recentJob;
    }

    public LongJob getJobByID(String jobID) {
        return this.jobMap.get(jobID);
    }

    public String[] getJobList() {
        return this.jobList.toArray(new String[0]);
    }

    public String[] getSnapshotList() {
        return this.getNode().getSnapshotList();
    }

    public int getNodesCount() {
        return this.getNode().getNodesCount();
    }

    public String startCreateSnapshot(String snapshotName) {
        String jobID = this.consNextJobID();
        String jobName = this.consJobName("createBackup", snapshotName);
        LongJob job = this.getNode().consCreateSnapshotJob(jobID, jobName, snapshotName);
        this.startJob(job);
        return jobID;
    }

    public String startDeleteSnapshot(String snapshotName) {
        String jobID = this.consNextJobID();
        String jobName = this.consJobName("deleteBackup", snapshotName);
        LongJob job = this.getNode().consDeleteSnapshotJob(jobID, jobName, snapshotName);
        this.startJob(job);
        return jobID;
    }

    public String startRestoreFromSnapshot(String snapshotName) {
        String jobID = this.consNextJobID();
        String jobName = this.consJobName("restoreBackup", snapshotName);
        LongJob job = this.getNode().consRestoreFromSnapshotJob(jobID, jobName, snapshotName);
        this.startJob(job);
        return jobID;
    }

    private String consJobName(String opName, String ... args) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(opName) + "(");
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(args[i]);
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CassandraNode getNode() {
        if (this.node == null) {
            StorageManager storageManager = this;
            synchronized (storageManager) {
                if (this.node == null) {
                    ServerConfig c = ServerConfig.getInstance();
                    this.node = new CassandraNode(c.dbhost, c.jmxport);
                }
            }
        }
        return this.node;
    }

    private synchronized void startJob(LongJob job) {
        if (this.future != null && !this.future.isDone()) {
            throw new IllegalStateException("Service busy. The \"" + this.recentJob.getName() + "\" job is in progress.");
        }
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        if (this.jobList.size() >= JOB_LIST_MAX_SIZE) {
            String firstId = this.jobList.get(0);
            this.jobList.remove(0);
            this.jobMap.remove(firstId);
        }
        this.recentJob = job;
        this.jobMap.put(job.getId(), job);
        this.jobList.add(job.getId());
        this.future = this.executor.submit((Runnable)job);
    }

    private synchronized String consNextJobID() {
        if (this.pid == null) {
            this.pid = this.getProcessId();
        }
        return String.valueOf(this.pid) + "-" + ++jobCount;
    }

    private String getProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index >= 1) {
            try {
                return Long.toString(Long.parseLong(jvmName.substring(0, index)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.logger.warn("Can't get current process id. Instead, using the JVM name: " + jvmName);
        return jvmName;
    }
}

