/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.mbeans;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.management.EventRate;
import com.dell.doradus.management.RequestsTracker;
import com.dell.doradus.management.ServerMonitorMXBean;
import com.dell.doradus.mbeans.MBeanBase;
import com.dell.doradus.mbeans.MeterMetric;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerMonitor
extends MBeanBase
implements ServerMonitorMXBean {
    private long startTime;
    private String version;
    private RequestsTracker allRequestsTracker;
    private RequestsTracker recentRequestsTracker;
    private AtomicInteger currentConnections = new AtomicInteger(0);
    private int databaseLink = -1;
    private ScheduledExecutorService exeService;
    private MeterMetric meter;

    public ServerMonitor(boolean publish) {
        this.domain = "com.dell.doradus";
        this.type = "ServerMonitor";
        if (publish) {
            this.register();
        }
        this.startTime = System.currentTimeMillis();
        this.version = this.getClass().getPackage().getImplementationVersion();
        this.allRequestsTracker = new RequestsTracker();
        this.recentRequestsTracker = new RequestsTracker();
        this.exeService = Executors.newSingleThreadScheduledExecutor();
        this.meter = MeterMetric.newMeter(this.exeService, "requests", TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.exeService.shutdown();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getReleaseVersion() {
        return this.version;
    }

    public Map<String, String> getServerConfig() {
        Map<String, Object> src = ServerConfig.getInstance().toMap();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String k : src.keySet()) {
            map.put(k, "" + src.get(k));
        }
        return map;
    }

    public int getDatabaseLink() {
        if (this.databaseLink < 0) {
            ServerConfig c = ServerConfig.getInstance();
            try {
                boolean[] local = new boolean[1];
                String dbhost = ServerMonitor.extractValidHostname(c.dbhost, local);
                this.databaseLink = local[0] ? 1 : 2;
                this.logger.info("Database hostname: " + dbhost + " (local=" + local[0] + ").");
            }
            catch (UnknownHostException ex) {
                this.logger.warn(ex.getMessage());
                this.databaseLink = 0;
            }
        }
        return this.databaseLink;
    }

    public RequestsTracker getAllRequests() {
        return this.allRequestsTracker;
    }

    public RequestsTracker getRecentRequests() {
        return this.recentRequestsTracker.snapshot(true);
    }

    public EventRate getThroughput() {
        return this.meter.toEventRate();
    }

    public int getConnectionsCount() {
        return this.currentConnections.get();
    }

    public String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public void setStartTime(long milliseconds) {
        this.startTime = milliseconds;
    }

    public void setReleaseVersion(String version) {
        this.version = version;
    }

    public void onConnectionOpened() {
        this.currentConnections.incrementAndGet();
    }

    public void onConnectionClosed() {
        this.currentConnections.decrementAndGet();
    }

    public synchronized void onNewRequest() {
        this.allRequestsTracker.onNewRequest();
        this.recentRequestsTracker.onNewRequest();
    }

    public synchronized void onRequestSucceeded(long startTimeInNanos) {
        long micros = (System.nanoTime() - startTimeInNanos) / 1000L;
        this.allRequestsTracker.onRequestSucceeded(micros);
        this.recentRequestsTracker.onRequestSucceeded(micros);
        this.meter.mark();
    }

    public synchronized void onRequestRejected(String reason) {
        this.allRequestsTracker.onRequestRejected(reason);
        this.recentRequestsTracker.onRequestRejected(reason);
        this.meter.mark();
    }

    public synchronized void onRequestFailed(String reason) {
        this.allRequestsTracker.onRequestFailed(reason);
        this.recentRequestsTracker.onRequestFailed(reason);
        this.meter.mark();
    }

    public synchronized void onRequestFailed(Throwable reason) {
        this.allRequestsTracker.onRequestFailed(reason);
        this.recentRequestsTracker.onRequestFailed(reason);
        this.meter.mark();
    }

    public synchronized void onRequestFailed(String message, Throwable ex) {
        String reason = String.valueOf(message) + ": " + ex.getClass().getName() + ": " + ex.getMessage();
        this.allRequestsTracker.onRequestFailed(reason);
        this.recentRequestsTracker.onRequestFailed(reason);
        this.meter.mark();
    }

    public static String extractValidHostname(String hostNameList, boolean[] localFound) throws UnknownHostException {
        boolean x;
        boolean bl = x = localFound != null && localFound.length > 0;
        if (x) {
            localFound[0] = false;
        }
        if (hostNameList != null && !"".equals(hostNameList = hostNameList.trim())) {
            String[] arr = hostNameList.split("[,;]");
            int i = 0;
            while (i < arr.length) {
                try {
                    InetAddress a = InetAddress.getByName(arr[i]);
                    if (x) {
                        if (a.isLoopbackAddress()) {
                            localFound[0] = true;
                        } else {
                            try {
                                localFound[0] = NetworkInterface.getByInetAddress(a) != null;
                            }
                            catch (SocketException socketException) {
                                // empty catch block
                            }
                        }
                    }
                    return arr[i];
                }
                catch (UnknownHostException unknownHostException) {
                    ++i;
                }
            }
            throw new UnknownHostException("No valid IP address could be found in the specification: \"" + hostNameList + "\".");
        }
        if (x) {
            localFound[0] = true;
        }
        return "127.0.0.1";
    }
}

