/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.mbeans;

import com.dell.doradus.management.EventRate;
import com.dell.doradus.mbeans.EWMA;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MeterMetric {
    private static final long INTERVAL = 5L;
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final AtomicLong count = new AtomicLong();
    private final long startTime = System.nanoTime();
    private final TimeUnit rateUnit;
    private final String eventType;
    private final ScheduledFuture<?> future;

    public static MeterMetric newMeter(ScheduledExecutorService tickThread, String eventType, TimeUnit rateUnit) {
        return new MeterMetric(tickThread, eventType, rateUnit);
    }

    private MeterMetric(ScheduledExecutorService tickThread, String eventType, TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        this.eventType = eventType;
        this.future = tickThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MeterMetric.this.tick();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    public String eventType() {
        return this.eventType;
    }

    void tick() {
        this.m1Rate.tick();
        this.m5Rate.tick();
        this.m15Rate.tick();
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.count.addAndGet(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    public long count() {
        return this.count.get();
    }

    public double fifteenMinuteRate() {
        return this.m15Rate.rate(this.rateUnit);
    }

    public double fiveMinuteRate() {
        return this.m5Rate.rate(this.rateUnit);
    }

    public double meanRate() {
        if (this.count() == 0L) {
            return 0.0;
        }
        long elapsed = System.nanoTime() - this.startTime;
        return this.convertNsRate((double)this.count() / (double)elapsed);
    }

    public double oneMinuteRate() {
        return this.m1Rate.rate(this.rateUnit);
    }

    public EventRate toEventRate() {
        EventRate rate = new EventRate(this.eventType, this.rateUnit);
        rate.update(this.count(), this.meanRate(), this.fifteenMinuteRate(), this.fiveMinuteRate(), this.oneMinuteRate());
        return rate;
    }

    private double convertNsRate(double ratePerNs) {
        return ratePerNs * (double)this.rateUnit.toNanos(1L);
    }

    void stop() {
        this.future.cancel(false);
    }
}

