/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.mbeans;

import com.dell.doradus.mbeans.MBeanProvider;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.rest.RESTService;

public final class MBeanService
extends Service {
    private static final MBeanService INSTANCE = new MBeanService();

    private MBeanService() {
    }

    public static MBeanService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        MBeanProvider.populateMBeanServer();
    }

    @Override
    public void startService() {
        RESTService.instance().registerRequestCallback(new ConnectionMonitor());
    }

    @Override
    public void stopService() {
        MBeanProvider.unpopulateMBeanServer();
    }

    private static class ConnectionMonitor
    implements RESTService.RequestCallback {
        private ConnectionMonitor() {
        }

        @Override
        public void onConnectionOpened() {
            if (INSTANCE.getState().isRunning()) {
                MBeanProvider.getServerMonitor().onConnectionOpened();
            }
        }

        @Override
        public void onConnectionClosed() {
            if (INSTANCE.getState().isRunning()) {
                MBeanProvider.getServerMonitor().onConnectionClosed();
            }
        }

        @Override
        public void onNewRequest() {
            if (INSTANCE.getState().isRunning()) {
                MBeanProvider.getServerMonitor().onNewRequest();
            }
        }

        @Override
        public void onRequestSucceeded(long startTimeNanos) {
            if (INSTANCE.getState().isRunning()) {
                MBeanProvider.getServerMonitor().onRequestSucceeded(startTimeNanos);
            }
        }

        @Override
        public void onRequestRejected(String reason) {
            if (INSTANCE.getState().isRunning()) {
                MBeanProvider.getServerMonitor().onRequestRejected(reason);
            }
        }

        @Override
        public void onRequestFailed(Throwable e) {
            if (INSTANCE.getState().isRunning()) {
                MBeanProvider.getServerMonitor().onRequestFailed(e);
            }
        }
    }
}

