/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.mbeans;

import com.dell.doradus.mbeans.ServerMonitor;
import com.dell.doradus.mbeans.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)MBeanProvider.class.getSimpleName());
    private static final Object lock = new Object();
    private static ServerMonitor serverMonitor;
    private static StorageManager storageManager;
    private static boolean populated;

    public static ServerMonitor getServerMonitor() {
        if (serverMonitor == null) {
            MBeanProvider.populateMBeanServer();
        }
        return serverMonitor;
    }

    public static StorageManager getStorageManager() {
        if (storageManager == null) {
            MBeanProvider.populateMBeanServer();
        }
        return storageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateMBeanServer() {
        if (populated) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            populated = true;
            if (serverMonitor == null) {
                logger.info("Creating and registering the ServerMonitor MXBean");
                try {
                    serverMonitor = new ServerMonitor(true);
                }
                catch (Exception ex) {
                    logger.warn("Can't publish ServerMonitor MXBean.", (Throwable)ex);
                    logger.warn("Nonpublic instance of the ServerMonitor MXBean will be used in current session.");
                    serverMonitor = new ServerMonitor(false);
                }
            }
            if (storageManager == null) {
                logger.info("Creating and registering the StorageManager MXBean");
                try {
                    storageManager = new StorageManager(true);
                }
                catch (Exception ex) {
                    logger.warn("Can't publish StorageManager MXBean.", (Throwable)ex);
                    logger.warn("Nonpublic instance of the StorageManager MXBean will be used in current session.");
                    storageManager = new StorageManager(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpopulateMBeanServer() {
        if (!populated) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            populated = false;
            if (storageManager != null && storageManager.getPublicName() != null) {
                logger.info("Unregistering the StorageManager MXBean");
                try {
                    storageManager.deregister();
                    storageManager.awaitJobTermination(120L);
                }
                catch (Exception ex) {
                    logger.warn("Can't unregister StorageManager MXBean.", (Throwable)ex);
                }
            }
            if (serverMonitor != null && serverMonitor.getPublicName() != null) {
                logger.info("Unregistering the ServerMonitor MXBean");
                try {
                    serverMonitor.deregister();
                    serverMonitor.shutdown();
                }
                catch (Exception ex) {
                    logger.warn("Can't unregister ServerMonitor MXBean.", (Throwable)ex);
                }
            }
            storageManager = null;
            serverMonitor = null;
        }
    }
}

