/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.mbeans;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanBase {
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    protected ObjectName objectName;
    protected String domain;
    protected String type;
    protected String keysString;

    public ObjectName getPublicName() {
        return this.objectName;
    }

    public void register() {
        try {
            this.objectName = this.consObjectName(this.domain, this.type, this.keysString);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            this.objectName = null;
            throw new RuntimeException(e);
        }
    }

    public void deregister() {
        if (this.objectName == null) {
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(this.objectName)) {
                mbs.unregisterMBean(this.objectName);
            }
            this.objectName = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectName consObjectName(String domain, String type, String keysString) {
        String d = domain != null && !"".equals(domain) ? domain : this.getDefaultDomain();
        String t = type != null && !"".equals(type) ? type : this.getDefaultType();
        String k = keysString != null && !"".equals(keysString) ? "," + keysString : "";
        try {
            return new ObjectName(String.valueOf(d) + ":type=" + t + k);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String getDefaultDomain() {
        return this.getClass().getPackage().getName();
    }

    protected String getDefaultType() {
        return this.getClass().getSimpleName();
    }
}

