/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.mbeans;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.management.LongJob;
import com.dell.doradus.mbeans.ServerMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraNode {
    private static final boolean DEBUG = false;
    private static final Logger logger = LoggerFactory.getLogger((String)CassandraNode.class.getSimpleName());
    private static final String SNAPSHOTS_DIR_NAME = "snapshots";
    private static float osversion;
    private static double cassandraVersion;
    public final int DEFAULT_JMX_PORT = 7199;
    private String host;
    private int port;
    private boolean isLocal;
    private JMXServiceURL jmxServiceURL;
    private MBeanServerConnection connection;
    private ObjectName storageServiceName;
    private ObjectName runtimeServiceName;
    private RuntimeMXBean runtimeServiceProxy;
    private ObjectName osServiceName;
    private OperatingSystemMXBean osServiceProxy;
    private String dbtoolName;
    private String dbtoolWorkDir;
    private Set<String> lockedMessages;

    static {
        cassandraVersion = -1.0;
    }

    public CassandraNode() {
        this(null, 0);
    }

    public CassandraNode(int port) {
        this(null, port);
    }

    public CassandraNode(String host, int port) {
        if (port <= 0) {
            port = 7199;
        }
        this.host = host;
        this.port = port;
        this.isLocal = this.isLocalHost();
        this.lockedMessages = Collections.synchronizedSet(new HashSet());
        try {
            this.storageServiceName = new ObjectName("org.apache.cassandra.db:type=StorageService");
            this.runtimeServiceName = new ObjectName("java.lang:type=Runtime");
            this.osServiceName = new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException ex) {
            logger.error("Program error.", (Throwable)ex);
        }
        String osv = System.getProperty("os.version");
        logger.debug("OS version: " + osv);
        while (osv.lastIndexOf(46) > osv.indexOf(46)) {
            osv = osv.substring(0, osv.lastIndexOf(46));
        }
        osversion = Float.parseFloat(osv);
        this.setDbtoolProps();
    }

    public String getOS() {
        try {
            OperatingSystemMXBean p = this.getOperatingSystemMXBeanProxy();
            return String.valueOf(p.getName()) + ", " + p.getArch();
        }
        catch (Exception ex) {
            this.throwException("getOS failed.", ex);
            return null;
        }
    }

    public boolean isNormal() {
        try {
            return "NORMAL".equals(this.getOperationMode());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isInForeground() {
        try {
            Map<String, String> props = this.getRuntimeMXBeanProxy().getSystemProperties();
            if (props.containsKey("cassandra-foreground")) {
                String fg = props.get("cassandra-foreground");
                return fg != null && "yes".equals(fg.toLowerCase());
            }
            return false;
        }
        catch (Exception ex) {
            this.throwException("isInForeground failed.", ex);
            return false;
        }
    }

    public LongJob consCreateSnapshotJob(String jobID, String jobName, String snapshotName) {
        final String sn = snapshotName;
        LongJob job = new LongJob(jobID, jobName){

            protected void doJob() throws Exception {
                this.progress = "Checking the node is in NORMAL mode...";
                if (!CassandraNode.this.isNormal()) {
                    throw new IllegalStateException("Cassandra-node is not in NORMAL operation mode. Try later, please.");
                }
                this.progress = "Invoking  the \"takeSnapshot\" on the Casandra's MBean...";
                CassandraNode.this.takeSnapshot(sn, new String[0]);
            }
        };
        return job;
    }

    public LongJob consDeleteSnapshotJob(String jobID, String jobName, String snapshotName) {
        final String sn = snapshotName;
        LongJob job = new LongJob(jobID, jobName){

            protected void doJob() throws Exception {
                this.progress = "Checking the node is in NORMAL mode...";
                if (!CassandraNode.this.isNormal()) {
                    throw new IllegalStateException("Cassandra-node is not in NORMAL operation mode. Try later, please.");
                }
                this.progress = "Invoking  the \"clearSnapshot\" on the Casandra's MBean...";
                CassandraNode.this.clearSnapshot(sn, new String[0]);
            }
        };
        return job;
    }

    double getVersionNumber() {
        if (cassandraVersion > 0.0) {
            return cassandraVersion;
        }
        String version = this.getReleaseVersion();
        if (version == null) {
            throw new IllegalStateException("Can't get Cassandra release version.");
        }
        String[] toks = version.split("\\.");
        if (toks.length >= 3) {
            try {
                StringBuilder b = new StringBuilder();
                int len = toks[0].length();
                if (len == 1) {
                    b.append("00");
                } else if (len == 2) {
                    b.append("0");
                }
                b.append(toks[0]);
                len = toks[1].length();
                if (len == 1) {
                    b.append("00");
                } else if (len == 2) {
                    b.append("0");
                }
                b.append(toks[1]);
                int i = 0;
                while (i < toks[2].length()) {
                    char c = toks[2].charAt(i);
                    if (!Character.isDigit(c)) break;
                    if (i == 0) {
                        b.append('.');
                    }
                    b.append(c);
                    ++i;
                }
                cassandraVersion = Double.valueOf(b.toString());
                return cassandraVersion;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Can't parse Cassandra release version string: \"" + version + "\"");
    }

    public LongJob consRestoreFromSnapshotJob(String jobID, String jobName, String snapshotName) {
        final String sn = snapshotName;
        LongJob job = new LongJob(jobID, jobName){

            protected void doJob() throws Exception {
                if (!CassandraNode.this.isLocal) {
                    throw new IllegalStateException("Cassandra-server and Doradus-server must be hosted on the same machine.");
                }
                if (!CassandraNode.this.isNormal()) {
                    throw new IllegalStateException("Cassandra-server is not in NORMAL operation mode. Try later, please.");
                }
                int vcode = CassandraNode.this.getVersionNumber() < 1001.0 ? 0 : 1;
                String srcName1 = vcode == 0 ? "keyspace" : "column_family";
                String srcName2 = vcode == 0 ? "keyspaces" : "column_families";
                logger.info("Starting the restoreFromSnapshot: " + sn);
                this.progress = "Searching for " + srcName2 + " which have this snapshot. ";
                logger.info(this.progress);
                String[] dataDirs = CassandraNode.this.getDataFileLocations();
                Map map = CassandraNode.this.getDataMap(vcode, dataDirs, sn);
                if (map.isEmpty()) {
                    logger.info("No one " + srcName1 + " has snapshot \"" + sn + "\".");
                    throw new IllegalArgumentException("No one " + srcName1 + " has snapshot \"" + sn + "\".");
                }
                String commitlogDir = CassandraNode.this.getCommitLogLocation();
                try {
                    StringBuilder errStr = new StringBuilder();
                    this.progress = "Stopping the Cassandra server ...";
                    logger.info(this.progress);
                    if (CassandraNode.this.execDbtool("STOP", errStr) != 0) {
                        logger.info("Can't stop Cassandra server.");
                        throw new RuntimeException("Can't stop Cassandra server:\n" + errStr.toString());
                    }
                    this.progress = "Clearing the commitlog directory ...";
                    logger.info(this.progress);
                    CassandraNode.this.clearDirectory(commitlogDir);
                    this.progress = "Clearing and restoring the data directories ...";
                    logger.info(this.progress);
                    int sz = map.size();
                    int i = 0;
                    for (File ks : map.keySet()) {
                        String pfx = "[" + ++i + "/" + sz + "] ";
                        this.progress = String.valueOf(pfx) + "Clearing directory: " + ks.getAbsolutePath();
                        logger.info(this.progress);
                        CassandraNode.this.clearDirectory(ks, null);
                        File snDir = (File)map.get(ks);
                        this.progress = String.valueOf(pfx) + "Restoring from:     " + snDir.getAbsolutePath();
                        logger.info(this.progress);
                        CassandraNode.this.copyFiles(snDir, ks);
                    }
                    errStr = new StringBuilder();
                    this.progress = "Starting the Cassandra server ...";
                    logger.info(this.progress);
                    if (CassandraNode.this.execDbtool("START", errStr) != 0) {
                        logger.info("Can't start Cassandra server.");
                        throw new RuntimeException("Can't start Cassandra server:\n" + errStr.toString());
                    }
                    logger.info("The restoreFromSnapshot succeeded.");
                }
                finally {
                    CassandraNode.this.resetConnection();
                }
            }
        };
        return job;
    }

    public String getReleaseVersion() {
        try {
            return (String)this.getConnection().getAttribute(this.storageServiceName, "ReleaseVersion");
        }
        catch (Exception ex) {
            this.throwException("getReleaseVersion failed.", ex);
            return null;
        }
    }

    public String getOperationMode() {
        try {
            return (String)this.getConnection().getAttribute(this.storageServiceName, "OperationMode");
        }
        catch (Exception ex) {
            this.throwException("getOperationMode failed.", ex);
            return null;
        }
    }

    public String getCommitLogLocation() {
        try {
            return (String)this.getConnection().getAttribute(this.storageServiceName, "CommitLogLocation");
        }
        catch (Exception ex) {
            this.throwException("getCommitLogLocation failed.", ex);
            return null;
        }
    }

    public String[] getDataFileLocations() {
        try {
            return (String[])this.getConnection().getAttribute(this.storageServiceName, "AllDataFileLocations");
        }
        catch (Exception ex) {
            this.throwException("getDataFileLocations failed.", ex);
            return null;
        }
    }

    public String getSavedCachesLocation() {
        try {
            return (String)this.getConnection().getAttribute(this.storageServiceName, "SavedCachesLocation");
        }
        catch (Exception ex) {
            this.throwException("getSavedCachesLocation failed.", ex);
            return null;
        }
    }

    public List getLiveNodes() {
        try {
            return (List)this.getConnection().getAttribute(this.storageServiceName, "LiveNodes");
        }
        catch (Exception ex) {
            this.throwException("getLiveNodes failed.", ex);
            return null;
        }
    }

    public List getLeavingNodes() {
        try {
            return (List)this.getConnection().getAttribute(this.storageServiceName, "LeavingNodes");
        }
        catch (Exception ex) {
            this.throwException("getLeavingNodes failed.", ex);
            return null;
        }
    }

    public List getMovingNodes() {
        try {
            return (List)this.getConnection().getAttribute(this.storageServiceName, "MovingNodes");
        }
        catch (Exception ex) {
            this.throwException("getMovingNodes failed.", ex);
            return null;
        }
    }

    public List getJoiningNodes() {
        try {
            return (List)this.getConnection().getAttribute(this.storageServiceName, "JoiningNodes");
        }
        catch (Exception ex) {
            this.throwException("getJoiningNodes failed.", ex);
            return null;
        }
    }

    public List getUnreachableNodes() {
        try {
            return (List)this.getConnection().getAttribute(this.storageServiceName, "UnreachableNodes");
        }
        catch (Exception ex) {
            this.throwException("getUnreachableNodes failed.", ex);
            return null;
        }
    }

    public int getNodesCount() {
        try {
            int size = 0;
            List nodes = (List)this.getConnection().getAttribute(this.storageServiceName, "UnreachableNodes");
            if (nodes != null) {
                size += nodes.size();
            }
            if ((nodes = (List)this.getConnection().getAttribute(this.storageServiceName, "JoiningNodes")) != null) {
                size += nodes.size();
            }
            if ((nodes = (List)this.getConnection().getAttribute(this.storageServiceName, "MovingNodes")) != null) {
                size += nodes.size();
            }
            if ((nodes = (List)this.getConnection().getAttribute(this.storageServiceName, "LeavingNodes")) != null) {
                size += nodes.size();
            }
            if ((nodes = (List)this.getConnection().getAttribute(this.storageServiceName, "LiveNodes")) != null) {
                size += nodes.size();
            }
            return size;
        }
        catch (Exception ex) {
            this.throwException("getNodesCount failed.", ex);
            return 0;
        }
    }

    public String getToken() {
        try {
            return (String)this.getConnection().getAttribute(this.storageServiceName, "Token");
        }
        catch (Exception ex) {
            this.throwException("getToken failed.", ex);
            return null;
        }
    }

    public String[] getSnapshotList() {
        if (!this.isLocal) {
            throw new IllegalStateException("Cassandra-node and Doradus-server must be hosted on the same machine.");
        }
        String[] dataDirs = this.getDataFileLocations();
        boolean vcode = !(this.getVersionNumber() < 1001.0);
        Map<File, File[]> map = !vcode ? this.getDataMap_1_0(dataDirs) : this.getDataMap_1_1(dataDirs);
        HashSet<String> snapshots = new HashSet<String>();
        for (File ks : map.keySet()) {
            File[] sn = map.get(ks);
            if (sn == null) continue;
            int i = 0;
            while (i < sn.length) {
                snapshots.add(sn[i].getName());
                ++i;
            }
        }
        return snapshots.toArray(new String[snapshots.size()]);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.jmxServiceURL;
    }

    public MBeanServerConnection getJMXServiceConnection() {
        return this.getConnection();
    }

    public void clearSnapshot(String snapshotName, String[] keySpaceList) {
        logger.info("Starting the clearSnapshot: " + snapshotName);
        try {
            try {
                String operationName = "clearSnapshot";
                Object[] arguments = new Object[]{snapshotName, keySpaceList};
                String[] signature = new String[]{String.class.getName(), String[].class.getName()};
                this.getConnection().invoke(this.storageServiceName, operationName, arguments, signature);
                logger.info("The clearSnapshot succeeded. ");
            }
            catch (Exception ex) {
                this.throwException("clearSnapshot failed.", ex);
                this.lockedMessages.remove("getDataMap");
                return;
            }
        }
        finally {
            this.lockedMessages.remove("getDataMap");
        }
    }

    public void takeSnapshot(String snapshotName, String[] keySpaceList) {
        logger.info("Starting the takeSnapshot: " + snapshotName);
        try {
            try {
                String operationName = "takeSnapshot";
                Object[] arguments = new Object[]{snapshotName, keySpaceList};
                String[] signature = new String[]{String.class.getName(), String[].class.getName()};
                this.getConnection().invoke(this.storageServiceName, operationName, arguments, signature);
                logger.info("The takeSnapshot succeeded. ");
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg != null && msg.indexOf("already") > 0 && msg.indexOf("exists") > 0) {
                    throw new IllegalStateException(msg);
                }
                this.throwException("takeSnapshot failed.", ex);
                this.lockedMessages.remove("getDataMap");
                return;
            }
        }
        finally {
            this.lockedMessages.remove("getDataMap");
        }
    }

    private MBeanServerConnection getConnection() {
        if (this.connection == null) {
            try {
                this.setConnection();
            }
            catch (Exception ex) {
                this.throwException("Can't create connection to MBean server", ex);
            }
        }
        return this.connection;
    }

    private OperatingSystemMXBean getOperatingSystemMXBeanProxy() {
        if (this.osServiceProxy == null) {
            try {
                this.setConnection();
            }
            catch (Exception ex) {
                this.throwException("Can't create proxy of OperatingSystemMXBean", ex);
            }
        }
        return this.osServiceProxy;
    }

    private RuntimeMXBean getRuntimeMXBeanProxy() {
        if (this.runtimeServiceProxy == null) {
            try {
                this.setConnection();
            }
            catch (Exception ex) {
                this.throwException("Can't create proxy of RuntimeMXBean", ex);
            }
        }
        return this.runtimeServiceProxy;
    }

    private synchronized void resetConnection() {
        this.connection = null;
        this.runtimeServiceProxy = null;
        this.osServiceProxy = null;
    }

    private synchronized void setConnection() throws IOException {
        if (this.connection == null) {
            this.jmxServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/jmxrmi");
            JMXConnector jmxc = JMXConnectorFactory.connect(this.jmxServiceURL, null);
            this.connection = jmxc.getMBeanServerConnection();
            this.runtimeServiceProxy = JMX.newMXBeanProxy(this.connection, this.runtimeServiceName, RuntimeMXBean.class);
            this.osServiceProxy = JMX.newMXBeanProxy(this.connection, this.osServiceName, OperatingSystemMXBean.class);
            logger.info("MBean server connected.");
            this.lockedMessages.clear();
        }
    }

    private void throwException(String prefix, Exception ex) {
        boolean writeToLog;
        String logmsg = this.consLogMsg(prefix, ex);
        String errmsg = this.consErrMsg(prefix, ex);
        boolean bl = writeToLog = this.connection != null;
        if (ConnectException.class.isInstance(ex)) {
            this.resetConnection();
            if (writeToLog) {
                logger.error(logmsg);
            }
            throw new RuntimeException(errmsg);
        }
        if (java.rmi.ConnectException.class.isInstance(ex)) {
            this.resetConnection();
            if (writeToLog) {
                logger.error(logmsg);
            }
            throw new RuntimeException(errmsg);
        }
        Throwable cause = ex.getCause();
        while (cause != null) {
            if (ConnectException.class.isInstance(cause)) {
                this.resetConnection();
                if (writeToLog) {
                    logger.error(logmsg);
                }
                throw new RuntimeException(String.valueOf(errmsg) + "\nCause: " + cause.getClass().getName() + ":\n" + cause.getMessage());
            }
            if (java.rmi.ConnectException.class.isInstance(cause)) {
                this.resetConnection();
                if (writeToLog) {
                    logger.error(logmsg);
                }
                throw new RuntimeException(String.valueOf(errmsg) + "\nCause: " + cause.getClass().getName() + ":\n" + cause.getMessage());
            }
            cause = cause.getCause();
        }
        if (writeToLog) {
            logger.error(logmsg);
        }
        throw new RuntimeException(prefix, ex);
    }

    private String consErrMsg(String prefix, Exception ex) {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.consLogMsg(prefix, ex);
    }

    private String consLogMsg(String prefix, Exception ex) {
        String msg = String.valueOf(ex.getClass().getName()) + ":\n" + ex.getMessage();
        if (prefix != null && prefix.length() > 0) {
            return String.valueOf(prefix) + ": " + msg;
        }
        return msg;
    }

    private void clearDirectory(String path) {
        this.clearDirectory(new File(path), null);
    }

    private void clearDirectory(File dir, String ext) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile() && (ext == null || file.getName().endsWith(ext))) {
                file.delete();
            }
            ++i;
        }
    }

    private void copyFiles(File srcDir, File dstDir) throws IOException {
        File[] src = srcDir.listFiles();
        int i = 0;
        while (i < src.length) {
            if (src[i].isFile()) {
                this.createHardLinkWithExec(src[i], new File(dstDir, src[i].getName()));
            }
            ++i;
        }
    }

    private void createHardLinkWithExec(File src, File dst) throws IOException {
        ProcessBuilder pb = osversion >= 6.0f ? new ProcessBuilder("cmd", "/c", "mklink", "/H", dst.getAbsolutePath(), src.getAbsolutePath()) : new ProcessBuilder("fsutil", "hardlink", "create", dst.getAbsolutePath(), src.getAbsolutePath());
        try {
            this.exec(pb);
        }
        catch (IOException ex) {
            String msg = "Unable to create hard link.  This probably means your data directory path is too long.  Exception follows: ";
            logger.error(msg, (Throwable)ex);
            throw ex;
        }
    }

    private void exec(ProcessBuilder pb) throws IOException {
        Process p = pb.start();
        try {
            try {
                int errCode = p.waitFor();
                if (errCode != 0) {
                    String str;
                    BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((str = in.readLine()) != null) {
                        sb.append(str).append(System.getProperty("line.separator"));
                    }
                    while ((str = err.readLine()) != null) {
                        sb.append(str).append(System.getProperty("line.separator"));
                    }
                    throw new IOException("Exception while executing the command: " + this.join(pb.command(), " ") + ". Error Code: " + errCode + ". Command output: " + sb.toString());
                }
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        finally {
            if (p != null) {
                p.getErrorStream().close();
                p.getInputStream().close();
                p.getOutputStream().close();
                p.destroy();
            }
        }
    }

    private String join(List<String> list, String sep) {
        StringBuilder b = new StringBuilder();
        for (String item : list) {
            b.append(String.valueOf(item) + sep);
        }
        return b.toString();
    }

    private int execDbtool(String commandName, StringBuilder errStr) throws IOException {
        String[] command;
        ServerConfig c = ServerConfig.getInstance();
        if (c.dbhome != null) {
            logger.debug("dbhome: " + c.dbhome);
            command = new String[]{this.dbtoolName, "-home", c.dbhome, commandName};
        } else {
            command = new String[]{this.dbtoolName, commandName};
        }
        return this.exec(command, this.dbtoolWorkDir, errStr);
    }

    private int exec(String[] command, String workingDir, StringBuilder errStr) throws IOException {
        String line;
        String cmdStr = Arrays.toString(command);
        logger.info("Executing " + cmdStr + ", workingDir: " + workingDir);
        String cmd = "[" + command[0] + "]";
        ProcessBuilder pb = new ProcessBuilder(command);
        if (workingDir != null) {
            pb.directory(new File(workingDir));
        }
        pb.redirectErrorStream(true);
        Process process = pb.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            if (line == null || line.isEmpty()) continue;
            logger.info(String.valueOf(cmd) + ": " + line);
            if ((errStr == null || !line.startsWith("Error")) && line.indexOf("Failed") < 0 && line.indexOf("Unable") < 0) continue;
            errStr.append(String.valueOf(line) + "\n");
        }
        try {
            int exitValue = process.waitFor();
            logger.info(String.valueOf(cmd) + " terminated with status: " + exitValue);
            return exitValue;
        }
        catch (InterruptedException e) {
            logger.warn("The waiting for " + cmd + " termination interrupted.");
            return 1;
        }
    }

    private Map<File, File[]> getDataMap_1_0(String[] dataDirs) {
        HashMap<File, File[]> map = new HashMap<File, File[]>();
        boolean doLog = false;
        if (!this.lockedMessages.contains("getDataMap")) {
            this.lockedMessages.add("getDataMap");
            doLog = true;
        }
        int i = 0;
        while (i < dataDirs.length) {
            File dir = new File(dataDirs[i]);
            if (!dir.canRead()) {
                if (doLog) {
                    logger.warn("Can't read: " + dir);
                }
            } else {
                File[] ksList = dir.listFiles();
                int j = 0;
                while (j < ksList.length) {
                    if (ksList[j].isDirectory()) {
                        ArrayList<File> snapshots = new ArrayList<File>();
                        File snDir = new File(ksList[j], SNAPSHOTS_DIR_NAME);
                        if (snDir.isDirectory()) {
                            File[] snList = snDir.listFiles();
                            int k = 0;
                            while (k < snList.length) {
                                if (snList[k].isDirectory()) {
                                    snapshots.add(snList[k]);
                                }
                                ++k;
                            }
                        }
                        map.put(ksList[j], snapshots.toArray(new File[snapshots.size()]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return map;
    }

    private Map<File, File[]> getDataMap_1_1(String[] dataDirs) {
        HashMap<File, File[]> map = new HashMap<File, File[]>();
        boolean doLog = false;
        if (!this.lockedMessages.contains("getDataMap")) {
            this.lockedMessages.add("getDataMap");
            doLog = true;
        }
        int i = 0;
        while (i < dataDirs.length) {
            File dir = new File(dataDirs[i]);
            if (!dir.canRead()) {
                if (doLog) {
                    logger.warn("Can't read: " + dir);
                }
            } else {
                File[] ksList = dir.listFiles();
                int j = 0;
                while (j < ksList.length) {
                    if (ksList[j].isDirectory()) {
                        File[] familyList = ksList[j].listFiles();
                        int n = 0;
                        while (n < familyList.length) {
                            if (familyList[n].isDirectory()) {
                                ArrayList<File> snapshots = new ArrayList<File>();
                                File snDir = new File(familyList[n], SNAPSHOTS_DIR_NAME);
                                if (snDir.isDirectory()) {
                                    File[] snList = snDir.listFiles();
                                    int k = 0;
                                    while (k < snList.length) {
                                        if (snList[k].isDirectory()) {
                                            snapshots.add(snList[k]);
                                        }
                                        ++k;
                                    }
                                }
                                map.put(familyList[n], snapshots.toArray(new File[snapshots.size()]));
                            }
                            ++n;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return map;
    }

    private Map<File, File> getDataMap(int vcode, String[] dataDirs, String snapshotName) {
        HashMap<File, File> map = new HashMap<File, File>();
        Map<File, File[]> src = vcode == 0 ? this.getDataMap_1_0(dataDirs) : this.getDataMap_1_1(dataDirs);
        block0: for (File ks : src.keySet()) {
            File[] sn = src.get(ks);
            if (sn == null) continue;
            int i = 0;
            while (i < sn.length) {
                if (snapshotName.equals(sn[i].getName())) {
                    map.put(ks, sn[i]);
                    continue block0;
                }
                ++i;
            }
        }
        return map;
    }

    private boolean isLocalHost() {
        if (this.host == null || "".equals(this.host)) {
            return true;
        }
        try {
            boolean[] local = new boolean[1];
            this.host = ServerMonitor.extractValidHostname(this.host, local);
            logger.debug("Database hostname: " + this.host + " (local=" + local[0] + ").");
            return local[0];
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
            return false;
        }
    }

    private void setDbtoolProps() {
        ServerConfig c = ServerConfig.getInstance();
        if (c.dbtool != null) {
            ClassLoader loader = ServerConfig.class.getClassLoader();
            URL url = loader.getResource(c.dbtool);
            if (url != null) {
                File f = new File(url.getFile());
                this.dbtoolName = f.getName();
                this.dbtoolWorkDir = f.getParent();
                logger.info("dbtoolName:    " + this.dbtoolName);
                logger.info("dbtoolWorkDir: " + this.dbtoolWorkDir);
            } else {
                logger.warn("\"" + c.dbtool + "\" file could not be found.");
            }
        } else {
            logger.warn("'dbtool' value is not defined in server configuration.");
        }
    }
}

