/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.io.BSTR;

public class Str
implements Comparable<Str> {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private byte[] m_buffer;
    private int m_offset;
    private int m_length;

    public Str() {
        this.clear();
    }

    public Str(byte[] buffer, int offset, int length) {
        this.set(buffer, offset, length);
    }

    public void set(byte[] buffer, int offset, int length) {
        this.m_buffer = buffer;
        this.m_offset = offset;
        this.m_length = length;
    }

    public void clear() {
        this.m_buffer = EMPTY_BUFFER;
        this.m_offset = 0;
        this.m_length = 0;
    }

    public void toBSTR(BSTR value) {
        value.assertLength(this.m_length);
        value.length = this.m_length;
        System.arraycopy(this.m_buffer, this.m_offset, value.buffer, 0, this.m_length);
    }

    @Override
    public int compareTo(Str other) {
        return Str.compare(this, other);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Str) {
            return Str.isEqual(this, (Str)obj);
        }
        return false;
    }

    public int hashCode() {
        return Str.hashCode(this);
    }

    public String toString() {
        return Utils.toString((byte[])this.m_buffer, (int)this.m_offset, (int)this.m_length);
    }

    public static int compare(Str x, Str y) {
        int l = Math.min(x.m_length, y.m_length);
        for (int i = 0; i < l; ++i) {
            char bx = (char)x.m_buffer[i];
            char by = (char)y.m_buffer[i];
            if (bx < by) {
                return -1;
            }
            if (bx <= by) continue;
            return 1;
        }
        if (x.m_length < y.m_length) {
            return -1;
        }
        if (x.m_length > y.m_length) {
            return 1;
        }
        return 0;
    }

    public static boolean isEqual(Str x, Str y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.m_length != y.m_length) {
            return false;
        }
        for (int i = 0; i < x.m_length; ++i) {
            if (x.m_buffer[i] == y.m_buffer[i]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(Str x) {
        int c = 0;
        for (int i = 0; i < x.m_length; ++i) {
            c *= 31;
            c += x.m_buffer[i];
        }
        return c;
    }
}

