/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.aggregate.SortOrder;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.Tenant;
import java.util.ArrayList;
import java.util.Iterator;

public class Searcher {
    public static TableDefinition getTableDef(Tenant tenant, String application) {
        ApplicationDefinition appDef = new ApplicationDefinition();
        appDef.setAppName(application);
        TableDefinition tableDef = new TableDefinition(appDef, "default");
        appDef.addTable(tableDef);
        FieldDefinition fieldDef = new FieldDefinition(tableDef);
        fieldDef.setType(FieldType.TIMESTAMP);
        fieldDef.setName("Timestamp");
        tableDef.addFieldDefinition(fieldDef);
        Iterator<DColumn> it = DBService.instance().getAllColumns(tenant, application, "fields");
        if (it != null) {
            while (it.hasNext()) {
                String field = it.next().getName();
                fieldDef = new FieldDefinition(tableDef);
                fieldDef.setType(FieldType.TEXT);
                fieldDef.setName(field);
                tableDef.addFieldDefinition(fieldDef);
            }
        }
        return tableDef;
    }

    public static BSTR[] getFields(FieldSet fieldSet) {
        ArrayList<BSTR> fields = new ArrayList<BSTR>(fieldSet.ScalarFields.size());
        for (String f : fieldSet.ScalarFields) {
            if ("Timestamp".equals(f)) continue;
            fields.add(new BSTR(f));
        }
        return fields.toArray(new BSTR[fields.size()]);
    }

    public static boolean isSortDescending(SortOrder[] order) {
        if (order == null || order.length == 0) {
            return false;
        }
        Utils.require((order.length == 1 ? 1 : 0) != 0, (String)"Cannot sort by more than one value");
        Utils.require((order[0].items.size() == 1 ? 1 : 0) != 0, (String)"Cannot sort by link path");
        Utils.require((boolean)"Timestamp".equals(order[0].items.get((int)0).name), (String)"Only sort by timestamp is supported");
        return !order[0].ascending;
    }
}

