/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.common.Utils;
import com.dell.doradus.logservice.ChunkReader;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.search.query.AllQuery;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.DatePartBinaryQuery;
import com.dell.doradus.search.query.NoneQuery;
import com.dell.doradus.search.query.NotQuery;
import com.dell.doradus.search.query.OrQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.RangeQuery;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class QueryFilter {
    public static boolean filter(Query query, ChunkReader reader, int doc) {
        if (query instanceof AllQuery) {
            return true;
        }
        if (query instanceof NoneQuery) {
            return false;
        }
        if (query instanceof NotQuery) {
            return !QueryFilter.filter(((NotQuery)query).innerQuery, reader, doc);
        }
        if (query instanceof AndQuery) {
            for (Query qu : ((AndQuery)query).subqueries) {
                if (QueryFilter.filter(qu, reader, doc)) continue;
                return false;
            }
            return true;
        }
        if (query instanceof OrQuery) {
            for (Query qu : ((OrQuery)query).subqueries) {
                if (!QueryFilter.filter(qu, reader, doc)) continue;
                return true;
            }
            return false;
        }
        if (query instanceof BinaryQuery) {
            boolean isPattern;
            String value;
            BinaryQuery bq = (BinaryQuery)query;
            String field = bq.field;
            if ("*".equals(field)) {
                field = null;
            }
            Utils.require(((value = bq.value) != null ? 1 : 0) != 0, (String)"is null not supported");
            value = value.toLowerCase(Locale.ROOT);
            if (field == null && "*".equals(value)) {
                return true;
            }
            Utils.require((!"Timestamp".equals(field) ? 1 : 0) != 0, (String)"Timestamp can be only in range query");
            boolean bl = isPattern = value.indexOf(42) >= 0 || value.indexOf(63) >= 0;
            if (field == null) {
                if (BinaryQuery.EQUALS.equals(bq.operation)) {
                    for (int i = 0; i < reader.fieldsCount(); ++i) {
                        String v = reader.getFieldValue(doc, i);
                        if (!(isPattern ? Utils.matchesPattern((String)v, (String)value) : v.toLowerCase(Locale.ROOT).equals(value))) continue;
                        return true;
                    }
                    return false;
                }
                if (BinaryQuery.CONTAINS.equals(bq.operation)) {
                    for (int i = 0; i < reader.fieldsCount(); ++i) {
                        String v = reader.getFieldValue(doc, i);
                        if (!(isPattern ? Utils.matchesPattern((String)v, (String)("*" + value + "*")) : v.toLowerCase(Locale.ROOT).contains(value))) continue;
                        return true;
                    }
                    return false;
                }
                if (BinaryQuery.REGEXP.equals(bq.operation)) {
                    for (int i = 0; i < reader.fieldsCount(); ++i) {
                        String v = reader.getFieldValue(doc, i);
                        if (!Pattern.matches(v, value)) continue;
                        return true;
                    }
                    return false;
                }
                throw new IllegalArgumentException("Only equals or contains or regexp are supported");
            }
            int fieldIndex = reader.getFieldIndex(new BSTR(field));
            if (fieldIndex < 0) {
                return false;
            }
            if (BinaryQuery.EQUALS.equals(bq.operation)) {
                String v = reader.getFieldValue(doc, fieldIndex);
                if (isPattern) {
                    return Utils.matchesPattern((String)v, (String)value);
                }
                return v.toLowerCase(Locale.ROOT).equals(value);
            }
            if (BinaryQuery.CONTAINS.equals(bq.operation)) {
                String v = reader.getFieldValue(doc, fieldIndex);
                if (isPattern) {
                    return Utils.matchesPattern((String)v, (String)("*" + value + "*"));
                }
                return v.toLowerCase(Locale.ROOT).contains(value);
            }
            if (BinaryQuery.REGEXP.equals(bq.operation)) {
                String v = reader.getFieldValue(doc, fieldIndex);
                return Pattern.matches(v, value);
            }
            throw new IllegalArgumentException("Only equals or contains or regexp are supported");
        }
        if (query instanceof RangeQuery) {
            RangeQuery rq = (RangeQuery)query;
            String field = rq.field;
            if ("Timestamp".equals(field)) {
                long timestamp;
                long minTimestamp = Long.MIN_VALUE;
                long maxTimestamp = Long.MAX_VALUE;
                if (rq.min != null) {
                    minTimestamp = Utils.parseDate((String)rq.min).getTimeInMillis();
                    if (!rq.minInclusive) {
                        ++minTimestamp;
                    }
                }
                if (rq.max != null) {
                    maxTimestamp = Utils.parseDate((String)rq.max).getTimeInMillis();
                    if (rq.maxInclusive) {
                        ++maxTimestamp;
                    }
                }
                return (timestamp = reader.getTimestamp(doc)) >= minTimestamp && timestamp < maxTimestamp;
            }
            int fieldIndex = reader.getFieldIndex(new BSTR(field));
            if (fieldIndex < 0) {
                return false;
            }
            String v = reader.getFieldValue(doc, fieldIndex);
            if (rq.min != null) {
                int c = v.compareTo(rq.min);
                if (rq.minInclusive && c < 0) {
                    return false;
                }
                return c > 0;
            }
            if (rq.max != null) {
                int c = v.compareTo(rq.max);
                if (rq.maxInclusive && c > 0) {
                    return false;
                }
                return c < 0;
            }
        }
        if (query instanceof DatePartBinaryQuery) {
            DatePartBinaryQuery dpq = (DatePartBinaryQuery)query;
            int datePart = dpq.part;
            BinaryQuery bq = dpq.innerQuery;
            String field = bq.field;
            String value = bq.value;
            Utils.require((boolean)BinaryQuery.EQUALS.equals(bq.operation), (String)"Contains is not supported");
            Utils.require((boolean)"Timestamp".equals(field), (String)"Only timestamp field is supported");
            Utils.require((value.indexOf(42) < 0 && value.indexOf(63) < 0 ? 1 : 0) != 0, (String)"Wildcard search not supported for DatePartBinaryQuery");
            int partValue = Integer.parseInt(value);
            if (datePart == 2) {
                --partValue;
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.setTimeInMillis(reader.getTimestamp(doc));
            return cal.get(datePart) == partValue;
        }
        throw new IllegalArgumentException("Query " + query.getClass().getSimpleName() + " not supported");
    }
}

