/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.BatchResult;
import com.dell.doradus.common.ContentType;
import com.dell.doradus.common.HttpCode;
import com.dell.doradus.common.RESTResponse;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.logservice.LogAggregate;
import com.dell.doradus.logservice.LogQuery;
import com.dell.doradus.logservice.LogService;
import com.dell.doradus.olap.OlapBatch;
import com.dell.doradus.olap.aggregate.AggregationResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.rest.ReaderCallback;
import com.dell.doradus.service.rest.UNodeOutCallback;
import com.dell.doradus.service.schema.SchemaService;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

public class LoggingService
extends StorageService {
    private static final LoggingService INSTANCE = new LoggingService();
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("POST /{application}                        com.dell.doradus.logservice.LoggingService$UpdateCmd"), new RESTCommand("PUT  /{application}                        com.dell.doradus.logservice.LoggingService$UpdateCmd"), new RESTCommand("GET  /{application}/_query?{params}        com.dell.doradus.logservice.LoggingService$QueryCmd"), new RESTCommand("GET  /{application}/_aggregate?{params}    com.dell.doradus.logservice.LoggingService$AggregateCmd"));
    private LogService m_logService = new LogService();

    private LoggingService() {
    }

    public static LoggingService instance() {
        return INSTANCE;
    }

    @Override
    protected void initService() {
        RESTService.instance().registerApplicationCommands(REST_RULES, this);
    }

    @Override
    protected void startService() {
        SchemaService.instance().waitForFullService();
    }

    @Override
    protected void stopService() {
    }

    @Override
    public void deleteApplication(ApplicationDefinition appDef) {
        this.checkServiceState();
        this.m_logService.deleteApplication(Tenant.getTenant(appDef), appDef.getAppName());
    }

    @Override
    public void initializeApplication(ApplicationDefinition oldAppDef, ApplicationDefinition appDef) {
        this.checkServiceState();
        this.m_logService.createApplication(Tenant.getTenant(appDef), appDef.getAppName());
    }

    @Override
    public void validateSchema(ApplicationDefinition appDef) {
        this.checkServiceState();
        this.validateApplication(appDef);
    }

    private void validateApplication(ApplicationDefinition appDef) {
        block8: for (String optName : appDef.getOptionNames()) {
            String optValue = appDef.getOption(optName);
            switch (optName) {
                case "StorageService": {
                    assert (optValue.equals(this.getClass().getSimpleName()));
                    continue block8;
                }
                case "Tenant": {
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown option for LoggingService application: " + optName);
        }
        Utils.require((appDef.getTableDefinitions().size() == 0 ? 1 : 0) != 0, (String)"Table definitions are not allowed with the LoggingService");
    }

    public static class AggregateCmd
    extends UNodeOutCallback {
        @Override
        public UNode invokeUNodeOut() {
            ApplicationDefinition appDef = this.m_request.getAppDef();
            Tenant tenant = this.m_request.getTenant();
            String params = this.m_request.getVariable("params");
            LogAggregate logAggregate = new LogAggregate(params);
            AggregationResult result = LoggingService.instance().m_logService.aggregate(tenant, appDef.getAppName(), logAggregate);
            return result.toUNode();
        }
    }

    public static class QueryCmd
    extends UNodeOutCallback {
        @Override
        public UNode invokeUNodeOut() {
            ApplicationDefinition appDef = this.m_request.getAppDef();
            Tenant tenant = this.m_request.getTenant();
            String params = this.m_request.getVariable("params");
            LogQuery logQuery = new LogQuery(params);
            SearchResultList searchResult = LoggingService.instance().m_logService.search(tenant, appDef.getAppName(), logQuery);
            return searchResult.toDoc();
        }
    }

    public static class UpdateCmd
    extends ReaderCallback {
        @Override
        public RESTResponse invokeStreamIn(Reader reader) {
            Utils.require((reader != null ? 1 : 0) != 0, (String)"This command requires an input entity");
            String application = this.m_request.getAppDef().getAppName();
            Tenant tenant = this.m_request.getTenant();
            OlapBatch batch = null;
            if (this.m_request.getInputContentType().isJSON()) {
                batch = OlapBatch.parseJSON(reader);
            } else {
                UNode rootNode = UNode.parse((Reader)reader, (ContentType)this.m_request.getInputContentType());
                batch = OlapBatch.fromUNode(rootNode);
            }
            LoggingService.instance().m_logService.addBatch(tenant, application, batch);
            return new RESTResponse(HttpCode.OK, new BatchResult().toDoc().toString(this.m_request.getOutputContentType()), this.m_request.getOutputContentType());
        }
    }
}

