/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.olap.ParsedQuery;

public class LogQuery {
    private String m_query;
    private int m_pageSize = -1;
    private int m_skip = 0;
    private String m_fields;
    private String m_sortOrder;
    private String m_continueAt;
    private String m_continueAfter;

    public LogQuery(UNode searchNode) {
        assert (searchNode != null);
        ParsedQuery parsedQuery = new ParsedQuery("search", searchNode);
        this.m_query = parsedQuery.get("query");
        this.m_pageSize = parsedQuery.getInt("size", -1);
        this.m_skip = parsedQuery.getInt("skip", 0);
        this.m_fields = parsedQuery.get("fields");
        this.m_sortOrder = parsedQuery.get("order");
        this.m_continueAt = parsedQuery.get("continue-at");
        this.m_continueAfter = parsedQuery.get("continue-after");
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public LogQuery(String queryParam) throws IllegalArgumentException {
        assert (queryParam != null);
        ParsedQuery parsedQuery = new ParsedQuery(queryParam);
        this.m_query = parsedQuery.get("q");
        this.m_pageSize = parsedQuery.getInt("s", -1);
        this.m_skip = parsedQuery.getInt("k", 0);
        this.m_fields = parsedQuery.get("f");
        this.m_sortOrder = parsedQuery.get("o");
        this.m_continueAt = parsedQuery.get("e");
        this.m_continueAfter = parsedQuery.get("g");
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public String getQuery() {
        return this.m_query;
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    public int getSkip() {
        return this.m_skip;
    }

    public String getFields() {
        return this.m_fields;
    }

    public String getSortOrder() {
        return this.m_sortOrder;
    }

    public String getContinueAt() {
        return this.m_continueAt;
    }

    public String getContinueAfter() {
        return this.m_continueAfter;
    }

    public int getPageSizeWithSkip() {
        if (this.m_pageSize < 0) {
            return this.m_skip + ServerConfig.getInstance().search_default_page_size;
        }
        if (this.m_pageSize == 0) {
            return Integer.MAX_VALUE;
        }
        return this.m_pageSize + this.m_skip;
    }

    private void checkDefaults() {
        Utils.require((this.m_continueAt == null || this.m_continueAfter == null ? 1 : 0) != 0, (String)"Both continue-at and continue-after parameters cannot be set");
        Utils.require((this.m_continueAt == null && this.m_continueAfter == null || this.m_sortOrder == null ? 1 : 0) != 0, (String)"continuation oarameters cannot be set if sort order is set");
        if (this.m_query == null) {
            this.m_query = "*";
        }
        if (this.m_pageSize == -1) {
            this.m_pageSize = ServerConfig.getInstance().search_default_page_size;
        }
    }
}

