/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.logservice.ChunkReader;
import com.dell.doradus.logservice.DateFormatter;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.SearchResult;

public class LogEntry
implements Comparable<LogEntry> {
    private int m_doc;
    private long m_timestamp;
    private BSTR[] m_fields;
    private BSTR[] m_values;
    private boolean m_bSortDescending;
    private DateFormatter m_formatter = new DateFormatter();

    public LogEntry(BSTR[] fields, boolean sortDescending) {
        this.m_fields = fields;
        this.m_values = new BSTR[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.m_values[i] = new BSTR();
        }
        this.m_bSortDescending = sortDescending;
    }

    public void set(ChunkReader reader, int doc) {
        this.m_doc = doc;
        this.m_timestamp = reader.getTimestamp(doc);
        for (int i = 0; i < this.m_fields.length; ++i) {
            int index = reader.getFieldIndex(this.m_fields[i]);
            if (index <= 0) {
                this.m_values[i].length = 0;
                continue;
            }
            reader.getFieldValue(doc, index, this.m_values[i]);
        }
    }

    @Override
    public int compareTo(LogEntry o) {
        int c = 0;
        if (this.m_timestamp > o.m_timestamp) {
            c = 1;
        } else if (this.m_timestamp < o.m_timestamp) {
            c = -1;
        }
        if (c == 0) {
            if (this.m_doc > o.m_doc) {
                c = 1;
            } else if (this.m_doc < o.m_doc) {
                c = -1;
            }
        }
        if (this.m_bSortDescending) {
            c = -c;
        }
        return c;
    }

    public SearchResult createSearchResult(FieldSet fieldSet) {
        SearchResult result = new SearchResult();
        result.fieldSet = fieldSet;
        String timestamp = this.m_formatter.format(this.m_timestamp);
        result.scalars.put("_ID", timestamp);
        result.scalars.put("Timestamp", timestamp);
        for (int i = 0; i < this.m_fields.length; ++i) {
            String field = this.m_fields[i].toString();
            String fieldAlias = fieldSet.ScalarFieldAliases.get(field);
            if (fieldAlias != null) {
                field = fieldAlias;
            }
            String value = this.m_values[i].toString();
            result.scalars.put(field, value);
        }
        return result;
    }
}

