/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.ParsedQuery;

public class LogAggregate {
    private String m_query;
    private String m_fields;
    private String m_metrics;

    public LogAggregate(UNode searchNode) {
        assert (searchNode != null);
        ParsedQuery parsedQuery = new ParsedQuery("aggregate-search", searchNode);
        this.m_query = parsedQuery.get("query");
        this.m_fields = parsedQuery.get("grouping-fields");
        Utils.require((parsedQuery.get("composite-fields") == null ? 1 : 0) != 0, (String)"OLAP queries cannot use composite grouping composite-fields parameter");
        this.m_metrics = parsedQuery.get("metric");
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public LogAggregate(String queryParam) throws IllegalArgumentException {
        assert (queryParam != null);
        ParsedQuery parsedQuery = new ParsedQuery(queryParam);
        this.m_query = parsedQuery.get("q");
        this.m_fields = parsedQuery.get("f");
        Utils.require((parsedQuery.get("cf") == null ? 1 : 0) != 0, (String)"OLAP queries cannot use composite grouping composite-fields parameter");
        this.m_metrics = parsedQuery.get("m");
        parsedQuery.checkInvalidParameters();
        this.checkDefaults();
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getFields() {
        return this.m_fields;
    }

    public String getMetrics() {
        return this.m_metrics;
    }

    private void checkDefaults() {
        if (this.m_query == null) {
            this.m_query = "*";
        }
        if (this.m_metrics == null) {
            this.m_metrics = "COUNT(*)";
        }
    }
}

