/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.logservice.Temp;
import com.dell.doradus.olap.collections.MemoryStream;
import com.dell.doradus.olap.collections.strings.BstrSet;
import com.dell.doradus.olap.io.BSTR;

public class FieldBuilder {
    private BSTR m_field;
    private BstrSet m_values;
    private int[] m_docs;

    public FieldBuilder(BSTR field, int size) {
        this.m_field = field;
        this.m_docs = new int[size];
        this.m_values = new BstrSet();
        int index = this.m_values.add(BSTR.EMPTY);
        if (index != 0) {
            throw new RuntimeException("Error insertin empty string");
        }
    }

    public void add(int doc, BSTR value) {
        int index;
        this.m_docs[doc] = index = this.m_values.add(value);
    }

    public void flush(MemoryStream output, Temp temp) {
        output.writeString(this.m_field);
        int fields_count = this.m_values.size();
        output.writeVInt(fields_count);
        int[] remap = this.m_values.sort();
        MemoryStream s_pfx = temp.getStream(0);
        MemoryStream s_sfx = temp.getStream(1);
        MemoryStream s_len = temp.getStream(2);
        MemoryStream s_dat = temp.getStream(3);
        BSTR last = temp.getBSTR();
        int[] m_doc_to_val = new int[remap.length];
        for (int i = 0; i < fields_count; ++i) {
            int sfx;
            int pfx;
            m_doc_to_val[remap[i]] = i;
            BSTR next = this.m_values.get(remap[i]);
            int l = Math.min(last.length, next.length);
            for (pfx = 0; pfx < l && last.buffer[pfx] == next.buffer[pfx]; ++pfx) {
            }
            for (sfx = 0; sfx < l - pfx && last.buffer[last.length - sfx - 1] == next.buffer[next.length - sfx - 1]; ++sfx) {
            }
            s_pfx.writeVInt(pfx);
            s_sfx.writeVInt(sfx);
            s_len.writeVInt(next.length);
            s_dat.write(next.buffer, pfx, next.length - sfx - pfx);
            last.set(next);
        }
        Temp.writeCompressed(output, s_pfx);
        Temp.writeCompressed(output, s_sfx);
        Temp.writeCompressed(output, s_len);
        Temp.writeCompressed(output, s_dat);
        MemoryStream s_lst = temp.getStream(0);
        MemoryStream s_fst = temp.getStream(1);
        for (int i = 0; i < this.m_docs.length; ++i) {
            int index = m_doc_to_val[this.m_docs[i]];
            s_lst.writeByte((byte)index);
            if (fields_count < 256) continue;
            s_fst.writeVInt(index >> 8);
        }
        Temp.writeCompressed(output, s_lst);
        if (fields_count >= 256) {
            Temp.writeCompressed(output, s_fst);
        }
    }
}

