/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.logservice.FieldBuilder;
import com.dell.doradus.logservice.Temp;
import com.dell.doradus.logservice.TimestampBuilder;
import com.dell.doradus.olap.OlapBatch;
import com.dell.doradus.olap.OlapDocument;
import com.dell.doradus.olap.collections.MemoryStream;
import com.dell.doradus.olap.io.BSTR;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ChunkWriter {
    private Temp m_temp = new Temp();
    private Map<BSTR, FieldBuilder> m_fields = new HashMap<BSTR, FieldBuilder>();
    private TimestampBuilder m_timestamps;
    private MemoryStream m_output = new MemoryStream();

    public Set<BSTR> getFields() {
        return this.m_fields.keySet();
    }

    public byte[] writeChunk(OlapBatch batch) {
        this.m_fields.clear();
        int size = batch.size();
        this.m_timestamps = new TimestampBuilder(size);
        for (int doc = 0; doc < size; ++doc) {
            OlapDocument d = batch.get(doc);
            this.m_timestamps.add(doc, d.getId());
            for (int i = 0; i < d.getFieldsCount(); ++i) {
                BSTR field = d.getFieldNameBinary(i);
                FieldBuilder fb = this.m_fields.get(field);
                if (fb == null) {
                    field = new BSTR(field);
                    fb = new FieldBuilder(field, size);
                    this.m_fields.put(field, fb);
                }
                fb.add(doc, d.getFieldValueBinary(i));
            }
        }
        this.m_output.clear();
        this.m_output.writeByte((byte)1);
        this.m_output.writeVInt(size);
        this.m_output.writeVInt(this.m_fields.size());
        this.m_timestamps.flush(this.m_output, this.m_temp);
        for (FieldBuilder fb : this.m_fields.values()) {
            fb.flush(this.m_output, this.m_temp);
        }
        return this.m_output.toArray();
    }
}

