/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.common.Utils;
import com.dell.doradus.logservice.LogRecord;
import com.dell.doradus.logservice.Str;
import com.dell.doradus.logservice.Temp;
import com.dell.doradus.olap.collections.MemoryStream;
import com.dell.doradus.olap.io.BSTR;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;

public class ChunkReader {
    private int m_size;
    private long[] m_timestamps;
    private MemoryStream m_data = new MemoryStream();
    private ArrayList<BSTR> m_fieldNames = new ArrayList();
    private ArrayList<int[]> m_offsets = new ArrayList();
    private ArrayList<int[]> m_lengths = new ArrayList();
    private HashMap<BSTR, Integer> m_fieldsMap = new HashMap();

    public void read(byte[] data) {
        this.m_data.clear();
        this.m_fieldNames.clear();
        this.m_offsets.clear();
        this.m_lengths.clear();
        this.m_fieldsMap.clear();
        MemoryStream input = new MemoryStream(data);
        byte version = (byte)input.readByte();
        if (version != 1) {
            throw new RuntimeException("Unknown format");
        }
        this.m_size = input.readVInt();
        int fieldsCount = input.readVInt();
        this.m_timestamps = new long[this.m_size];
        MemoryStream s_ts = Temp.readCompressed(input);
        long last = 0L;
        for (int i = 0; i < this.m_size; ++i) {
            this.m_timestamps[i] = last += s_ts.readVLong();
        }
        for (int f = 0; f < fieldsCount; ++f) {
            MemoryStream s_lst;
            BSTR field = new BSTR(input.readString());
            int valuesCount = input.readVInt();
            int[] positions = new int[this.m_size];
            int[] lengths = new int[this.m_size];
            this.m_fieldNames.add(field);
            this.m_offsets.add(positions);
            this.m_lengths.add(lengths);
            this.m_fieldsMap.put(field, new Integer(f));
            MemoryStream s_pfx = Temp.readCompressed(input);
            MemoryStream s_sfx = Temp.readCompressed(input);
            MemoryStream s_len = Temp.readCompressed(input);
            MemoryStream s_dat = Temp.readCompressed(input);
            int lastPos = this.m_data.position();
            int lastLen = 0;
            int[] offsets = new int[valuesCount];
            int[] lens = new int[valuesCount];
            for (int i = 0; i < valuesCount; ++i) {
                int pfx = s_pfx.readVInt();
                int sfx = s_sfx.readVInt();
                int len = s_len.readVInt();
                offsets[i] = this.m_data.position();
                lens[i] = len;
                int ifx = len - sfx - pfx;
                if (pfx > 0) {
                    this.m_data.write(this.m_data.getBuffer(), lastPos, pfx);
                }
                if (ifx > 0) {
                    this.m_data.write(s_dat.getBuffer(), s_dat.position(), ifx);
                    s_dat.skip(ifx);
                }
                if (sfx > 0) {
                    this.m_data.write(this.m_data.getBuffer(), lastPos + lastLen - sfx, sfx);
                }
                lastPos = offsets[i];
                lastLen = len;
            }
            if (valuesCount >= 256) {
                s_lst = Temp.readCompressed(input);
                MemoryStream s_fst = Temp.readCompressed(input);
                for (int i = 0; i < this.m_size; ++i) {
                    int n = (s_fst.readVInt() << 8) + s_lst.readByte();
                    positions[i] = offsets[n];
                    lengths[i] = lens[n];
                }
                continue;
            }
            s_lst = Temp.readCompressed(input);
            for (int i = 0; i < this.m_size; ++i) {
                int n = s_lst.readByte();
                positions[i] = offsets[n];
                lengths[i] = lens[n];
            }
        }
        if (!input.end()) {
            throw new RuntimeException("Unexpected data");
        }
    }

    public int size() {
        return this.m_size;
    }

    public int fieldsCount() {
        return this.m_fieldNames.size();
    }

    public long getTimestamp(int doc) {
        return this.m_timestamps[doc];
    }

    public Date getDate(int doc) {
        return new Date(this.getTimestamp(doc));
    }

    public ArrayList<BSTR> getFieldNames() {
        return this.m_fieldNames;
    }

    public int getFieldIndex(BSTR field) {
        Integer i = this.m_fieldsMap.get(field);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void getFieldValue(int doc, int field, BSTR value) {
        value.length = 0;
        int[] offsets = this.m_offsets.get(field);
        int[] lengths = this.m_lengths.get(field);
        this.m_data.seek(offsets[doc]);
        int len = lengths[doc];
        value.assertLength(len);
        this.m_data.read(value.buffer, 0, len);
        value.length = len;
    }

    public void getFieldValue(int doc, int field, Str value) {
        value.clear();
        int[] offsets = this.m_offsets.get(field);
        int[] lengths = this.m_lengths.get(field);
        value.set(this.m_data.getBuffer(), offsets[doc], lengths[doc]);
    }

    public String getFieldValue(int doc, int field) {
        int[] offsets = this.m_offsets.get(field);
        int[] lengths = this.m_lengths.get(field);
        return Utils.toString((byte[])this.m_data.getBuffer(), (int)offsets[doc], (int)lengths[doc]);
    }

    public void load(int doc, LogRecord record) {
        record.setFieldsCount(this.fieldsCount());
        record.clear();
        record.setTimestamp(this.m_timestamps[doc]);
        for (int f = 0; f < this.fieldsCount(); ++f) {
            Str value = record.fieldValue(f);
            this.getFieldValue(doc, f, value);
        }
    }
}

