/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.logservice;

import com.dell.doradus.logservice.ChunkReader;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.Tenant;
import java.util.Iterator;

public class ChunkIterator
implements Iterator<ChunkReader> {
    private Tenant m_tenant;
    private String m_application;
    private String m_partition;
    private Iterator<DColumn> m_iterator;
    private ChunkReader m_chunk;

    public ChunkIterator(Tenant tenant, String application, String partition) {
        this.m_tenant = tenant;
        this.m_application = application;
        this.m_partition = partition;
        this.m_iterator = DBService.instance().getAllColumns(this.m_tenant, this.m_application, "partitions_" + this.m_partition);
        this.m_chunk = new ChunkReader();
    }

    @Override
    public boolean hasNext() {
        return this.m_iterator != null && this.m_iterator.hasNext();
    }

    @Override
    public ChunkReader next() {
        String chunkid = this.m_iterator.next().getName();
        DColumn column = DBService.instance().getColumn(this.m_tenant, this.m_application, this.m_partition, chunkid);
        this.m_chunk.read(column.getRawValue());
        return this.m_chunk;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove not implemented");
    }
}

