/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.fieldanalyzer;

import com.dell.doradus.common.FieldType;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.fieldanalyzer.OpaqueTextAnalyzer;
import com.dell.doradus.search.analyzer.SimpleText;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TextAnalyzer
extends FieldAnalyzer {
    private static final TextAnalyzer INSTANCE = new TextAnalyzer();

    public static TextAnalyzer instance() {
        return INSTANCE;
    }

    private TextAnalyzer() {
    }

    @Override
    public String[] tokenize(String value) {
        List<String> tokens = new SimpleText().tokenize(value);
        tokens.add("'" + OpaqueTextAnalyzer.getOpaqueTerm(value) + "'");
        return tokens.toArray(new String[tokens.size()]);
    }

    @Override
    protected Collection<FieldType> getCompatibleFieldTypes() {
        return Arrays.asList(FieldType.TEXT);
    }
}

