/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.fieldanalyzer;

import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.Utils;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import java.util.Arrays;
import java.util.Collection;

public class OpaqueTextAnalyzer
extends FieldAnalyzer {
    private static final OpaqueTextAnalyzer INSTANCE = new OpaqueTextAnalyzer();

    public static OpaqueTextAnalyzer instance() {
        return INSTANCE;
    }

    private OpaqueTextAnalyzer() {
    }

    @Override
    public String[] tokenize(String value) {
        return new String[]{OpaqueTextAnalyzer.getOpaqueTerm(value)};
    }

    public static String getOpaqueTerm(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.toLowerCase()).length() >= 1024) {
            value = Utils.md5Encode((String)value);
        }
        return value;
    }

    @Override
    protected Collection<FieldType> getCompatibleFieldTypes() {
        return Arrays.asList(FieldType.TEXT);
    }
}

