/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.fieldanalyzer;

import com.dell.doradus.common.FieldType;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.search.analyzer.NumericTrie;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class IntegerAnalyzer
extends FieldAnalyzer {
    public static final long MAXIMUM_VALUE = 0x4000000000000L;
    private static final IntegerAnalyzer INSTANCE = new IntegerAnalyzer();

    public static IntegerAnalyzer instance() {
        return INSTANCE;
    }

    private IntegerAnalyzer() {
    }

    @Override
    public String[] tokenize(String value) {
        long val = Long.parseLong(value);
        List<String> tokens = new NumericTrie(32).tokenize(val);
        return tokens.toArray(new String[tokens.size()]);
    }

    @Override
    protected Collection<FieldType> getCompatibleFieldTypes() {
        return Arrays.asList(FieldType.INTEGER, FieldType.LONG);
    }
}

