/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.fieldanalyzer;

import com.dell.doradus.common.FieldType;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.search.analyzer.SimpleText;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HTMLAnalyzer
extends FieldAnalyzer {
    private static final ParserDelegator s_parser = new ParserDelegator();
    private static final HTMLAnalyzer INSTANCE = new HTMLAnalyzer();

    public static HTMLAnalyzer instance() {
        return INSTANCE;
    }

    private HTMLAnalyzer() {
    }

    @Override
    public String[] tokenize(String value) {
        StringReader reader = new StringReader(value);
        HTMLParserCallback callback = new HTMLParserCallback();
        try {
            s_parser.parse(reader, callback, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return callback.m_tokens.toArray(new String[0]);
    }

    @Override
    protected Collection<FieldType> getCompatibleFieldTypes() {
        return Arrays.asList(FieldType.TEXT);
    }

    class HTMLParserCallback
    extends HTMLEditorKit.ParserCallback {
        List<String> m_tokens = new LinkedList<String>();

        HTMLParserCallback() {
        }

        @Override
        public void handleText(char[] data, int pos) {
            String value = new String(data);
            this.m_tokens.addAll(new SimpleText().tokenize(value));
        }
    }
}

