/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.fieldanalyzer;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.fieldanalyzer.TextAnalyzer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public abstract class FieldAnalyzer {
    private static final String DEFAULT_ANALYZER_PACKAGE = "com.dell.doradus.fieldanalyzer.";
    private static final String INSTANCE_METHOD_NAME = "instance";
    private static final Map<String, FieldAnalyzer> g_analyzerCache = new Hashtable<String, FieldAnalyzer>();
    private final Collection<FieldType> m_compatibleTypes = this.getCompatibleFieldTypes();

    protected FieldAnalyzer() {
    }

    protected abstract Collection<FieldType> getCompatibleFieldTypes();

    public static FieldAnalyzer findAnalyzer(FieldDefinition fieldDef) {
        Utils.require((boolean)fieldDef.isScalarField(), (String)"Must be a scalar field: %s", (Object[])new Object[]{fieldDef});
        String analyzerName = fieldDef.getAnalyzerName();
        Utils.require((analyzerName != null ? 1 : 0) != 0, (String)"Scalar field has no analyzer: %s", (Object[])new Object[]{fieldDef});
        return FieldAnalyzer.findAnalyzer(analyzerName);
    }

    public static FieldAnalyzer findAnalyzer(TableDefinition tableDef, String fieldName) {
        assert (tableDef != null);
        assert (fieldName != null);
        FieldAnalyzer analyzer = TextAnalyzer.instance();
        FieldDefinition fieldDef = tableDef.getFieldDef(fieldName);
        if (fieldDef != null) {
            Utils.require((boolean)fieldDef.isScalarField(), (String)("Must be a scalar field: " + fieldDef));
            analyzer = FieldAnalyzer.findAnalyzer(fieldDef.getAnalyzerName());
        }
        return analyzer;
    }

    public static FieldAnalyzer findAnalyzer(String analyzerName) {
        FieldAnalyzer fieldAnalyzer;
        Utils.require((!Utils.isEmpty((String)analyzerName) ? 1 : 0) != 0, (String)"analyzerName");
        if (analyzerName.indexOf(46) < 0 && !(analyzerName = DEFAULT_ANALYZER_PACKAGE + analyzerName).endsWith("Analyzer")) {
            analyzerName = String.valueOf(analyzerName) + "Analyzer";
        }
        if ((fieldAnalyzer = g_analyzerCache.get(analyzerName)) != null) {
            return fieldAnalyzer;
        }
        try {
            Class<?> analyzerClass = Class.forName(analyzerName);
            Method instanceMethod = analyzerClass.getMethod(INSTANCE_METHOD_NAME, new Class[0]);
            fieldAnalyzer = (FieldAnalyzer)instanceMethod.invoke(null, new Object[0]);
            g_analyzerCache.put(analyzerName, fieldAnalyzer);
            return fieldAnalyzer;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Analyzer not found: " + analyzerName);
        }
    }

    public static void verifyAnalyzer(FieldDefinition fieldDef) {
        assert (fieldDef != null);
        FieldAnalyzer analyzer = FieldAnalyzer.findAnalyzer(fieldDef);
        Utils.require((boolean)analyzer.compatibleFieldTypes().contains(fieldDef.getType()), (String)"Invalid analyzer for field type '%s': %s", (Object[])new Object[]{fieldDef.getType(), fieldDef.getAnalyzerName()});
    }

    public abstract String[] tokenize(String var1);

    public Collection<FieldType> compatibleFieldTypes() {
        return this.m_compatibleTypes;
    }

    public Set<String> extractTerms(String value) {
        try {
            HashSet<String> result = new HashSet<String>();
            Set split = Utils.split((String)value.toLowerCase(), (String)"\ufffe");
            for (String s : split) {
                String[] tokens;
                String[] stringArray = tokens = this.tokenize(s);
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (token.length() != 0) {
                        result.add(token);
                    }
                    ++n2;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing field value: " + e.getLocalizedMessage());
        }
    }

    public String formTermKey(String fieldName, String term) {
        return String.valueOf(fieldName) + "/" + term;
    }

    public static String makeTermKey(String field, String term) {
        return String.valueOf(field) + "/" + term.toLowerCase();
    }

    public static String makeAllKey() {
        return "_";
    }
}

