/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.fieldanalyzer;

import com.dell.doradus.common.FieldType;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.fieldanalyzer.OpaqueTextAnalyzer;
import java.util.Arrays;
import java.util.Collection;

public class BooleanAnalyzer
extends FieldAnalyzer {
    private static final BooleanAnalyzer INSTANCE = new BooleanAnalyzer();

    public static BooleanAnalyzer instance() {
        return INSTANCE;
    }

    private BooleanAnalyzer() {
    }

    @Override
    public String[] tokenize(String value) {
        if (!value.equalsIgnoreCase("True") && !value.equalsIgnoreCase("False")) {
            throw new RuntimeException("Boolean field must have only 'True' or 'False' values; instead found '" + value + "'");
        }
        return OpaqueTextAnalyzer.instance().tokenize(value);
    }

    @Override
    protected Collection<FieldType> getCompatibleFieldTypes() {
        return Arrays.asList(FieldType.BOOLEAN);
    }
}

