/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.core;

import com.dell.doradus.common.ConfigurationException;
import com.dell.doradus.common.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class ServerConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)ServerConfig.class.getSimpleName());
    private static ServerConfig config;
    public static final String DEFAULT_CONFIG_URL = "doradus.yaml";
    public static final String CONFIG_URL_PROPERTY_NAME = "doradus.config";
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    public static final String DEFAULT_PARAM_OVERRIDE_FILE_PARAM = "param_override_filename";
    public static final String DEFAULT_DB_HOST = "localhost";
    public static final int DEFAULT_DB_PORT = 9160;
    public static final int DEFAULT_JMX_PORT = 7199;
    public static final String DEFAULT_KS_NAME = "Doradus";
    public static final int DEFAULT_REST_PORT = 1123;
    public static final int DEFAULT_MAX_THREADS = 200;
    public static final int DEFAULT_MIN_THREADS = 10;
    public static final int DEFAULT_IDLE_TIMEOUT = 600000;
    public static final int DEFAULT_TASK_QUEUE = 600;
    public static final String DEFAULT_DBTOOL_NAME = "doradus-cassandra.bat";
    public static final String DEFAULT_AGING_RECHECK = "4 hours";
    public static final boolean DEFAULT_AGGR_SEPARATE_SEARH = false;
    public static final int DEFAULT_AGGR_CONCURRENT_THREADS = 8;
    public static final int DEFAULT_MAX_REQUEST_SIZE = 0x3200000;
    public static final int DEFAULT_DBESOPTIONS_ENTITY_BUFFER = 1000;
    public static final int DEFAULT_DBESOPTIONS_LINK_BUFFER = 1000;
    public static final int DEFAULT_DBESOPTIONS_INITIAL_LINK_BUFFER = 10;
    public static final int DEFAULT_DBESOPTIONS_INITIAL_LINK_BUFFER_DIMENSION = 1000;
    public static final int DEFAULT_DBESOPTIONS_INITIAL_SCALAR_BUFFER = 30;
    public static final int DEFAULT_DB_TIMEOUT_MILLIS = 10000;
    public static final int DEFAULT_MAX_COMMIT_ATTEMPTS = 10;
    public static final int DEFAULT_MAX_READ_ATTEMPTS = 3;
    public static final int DEFAULT_RETRY_WAIT_MILLIS = 5000;
    public static final int DEFAULT_MAX_RECONNECT_ATTEMPTS = 3;
    public static final int DEFAULT_DB_CONNECT_RETRY_WAIT_MILLIS = 5000;
    public static final int DEFAULT_BATCH_MUTATION_THRESHOLD = 10000;
    public static final String DEFAULT_DATA_CHECK_SHARD_GRAN = "1 DAY";
    public Map<String, Object> ks_defaults = new HashMap<String, Object>();
    public Map<String, Object> cf_defaults = new HashMap<String, Object>();
    public boolean load_webserver = false;
    public String webserver_class;
    public List<String> default_services = new ArrayList<String>();
    public List<String> storage_services = new ArrayList<String>();
    public String dbhost = "localhost";
    public String secondary_dbhost = null;
    public int dbport = 9160;
    public boolean dbtls = false;
    public List<String> dbtls_cipher_suites = new ArrayList<String>();
    public String dbuser;
    public String dbpassword;
    public int jmxport = 7199;
    public boolean multitenant_mode = false;
    public String keyspace = "Doradus";
    public boolean disable_default_keyspace = false;
    public int restport = 1123;
    public String restaddr;
    public int maxconns = 200;
    public int defaultMinThreads = 10;
    public int maxTaskQueue = 600;
    public int defaultIdleTimeout = 600000;
    public boolean tls = false;
    public List<String> tls_cipher_suites = new ArrayList<String>();
    public boolean clientauthentication = false;
    public String keystore;
    public String keystorepassword;
    public String truststore;
    public String truststorepassword;
    public String dbhome = null;
    public String dbtool = "doradus-cassandra.bat";
    public String aging_recheck_freq = "4 hours";
    public boolean aggr_separate_search = false;
    public int aggr_concurrent_threads = 8;
    public int max_request_size = 0x3200000;
    public int dbesoptions_entityBuffer = 1000;
    public int dbesoptions_linkBuffer = 1000;
    public int dbesoptions_initialLinkBuffer = 10;
    public int dbesoptions_initialLinkBufferDimension = 1000;
    public int dbesoptions_initialScalarBuffer = 30;
    public boolean l2r_enable = true;
    public int search_default_page_size = 100;
    public int search_column_count = 1024;
    public int search_link_column_count = 16384;
    public int search_link_thread_count = 0;
    public int search_max_linked_objects = 100000;
    public int search_worker_pool_size = 32;
    public int db_timeout_millis = 10000;
    public int primary_host_recheck_millis = 60000;
    public int max_commit_attempts = 10;
    public int max_read_attempts = 3;
    public int retry_wait_millis = 5000;
    public int max_reconnect_attempts = 3;
    public int db_connect_retry_wait_millis = 5000;
    public int batch_mutation_threshold = 10000;
    public Map<String, Object> olap_cf_defaults = new HashMap<String, Object>();
    public int olap_loaded_segments = 8192;
    public boolean olap_internal_compression = true;
    public int olap_cache_size_mb = 100;
    public int olap_file_cache_size_mb = 0;
    public int olap_query_cache_size_mb = 100;
    public int olap_merge_threads = 0;
    public int olap_compression_threads = 0;
    public int olap_search_threads = 0;
    public int olap_compression_level = -1;
    public boolean use_cql = true;
    public boolean async_updates = false;
    public String param_override_filename;

    public static ServerConfig getInstance() {
        if (config == null) {
            throw new IllegalStateException("The configuration singleton was not initialized. Call the load() method on app's startup. ");
        }
        return config;
    }

    public static ServerConfig load(String[] args) throws ConfigurationException {
        if (config != null) {
            logger.warn("Configuration is loaded already. Use ServerConfig.getInstance() method. ");
            return config;
        }
        try {
            URL url = ServerConfig.getConfigUrl();
            logger.info("Trying to load settings from: " + url);
            InputStream input = null;
            try {
                input = url.openStream();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            Yaml yaml = new Yaml();
            LinkedHashMap dataColl = (LinkedHashMap)yaml.load(input);
            config = new ServerConfig();
            ServerConfig.setParams(dataColl);
            logger.info("Ok. Configuration loaded.");
        }
        catch (ConfigurationException e) {
            logger.warn(String.valueOf(e.getMessage()) + " -- Ignoring.");
        }
        catch (YAMLException e) {
            logger.warn(String.valueOf(e.getMessage()) + " -- Ignoring.");
        }
        if (config == null) {
            logger.info("Initializing configuration by default settings.");
            config = new ServerConfig();
        }
        try {
            if (args != null && args.length > 0) {
                logger.info("Parsing the command line arguments...");
                ServerConfig.parseCommandLineArgs(args);
                logger.info("Ok. Arguments parsed.");
            }
        }
        catch (ConfigurationException e) {
            logger.error("Fatal configuration error", (Throwable)e);
            System.err.println(String.valueOf(e.getMessage()) + "\nFatal configuration error. Unable to start server.  See log for stacktrace.");
            throw e;
        }
        if (!Utils.isEmpty((String)ServerConfig.config.param_override_filename)) {
            try {
                FileInputStream overrideFile = new FileInputStream(ServerConfig.config.param_override_filename);
                Yaml yaml = new Yaml();
                LinkedHashMap overrideColl = (LinkedHashMap)yaml.load((InputStream)overrideFile);
                ServerConfig.setParams(overrideColl);
            }
            catch (Exception e) {
                logger.warn(String.valueOf(e.getMessage()) + " -- Ignoring.");
            }
        }
        return config;
    }

    public static void unload() {
        config = null;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = ServerConfig.class.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field f = fields[i];
            int m = f.getModifiers();
            if (Modifier.isPublic(m) && !Modifier.isStatic(m)) {
                try {
                    map.put(f.getName(), f.get(this));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return map;
    }

    private static URL getConfigUrl() throws ConfigurationException {
        ClassLoader loader;
        String spec = System.getProperty(CONFIG_URL_PROPERTY_NAME);
        if (spec == null) {
            spec = DEFAULT_CONFIG_URL;
        }
        URL configUrl = null;
        try {
            configUrl = new URL(spec);
            configUrl.openStream().close();
        }
        catch (Exception e) {
            try {
                File f = new File(spec);
                if (f.exists()) {
                    configUrl = new URL("file:///" + f.getCanonicalPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (configUrl == null && (configUrl = (loader = ServerConfig.class.getClassLoader()).getResource(spec)) == null) {
            throw new ConfigurationException("Can't find file/resource: \"" + spec + "\".");
        }
        return configUrl;
    }

    private static void parseCommandLineArgs(String[] args) throws ConfigurationException {
        if (args[0].equalsIgnoreCase("-?") || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("/?") || args[0].equalsIgnoreCase("-help")) {
            System.out.println("See documentation and doradus.yaml and options");
            System.exit(0);
        }
        ArrayList<String> unknownArgs = new ArrayList<String>();
        int inx = 0;
        while (inx < args.length) {
            String value;
            String name = args[inx].substring(1);
            if (inx + 1 >= args.length) {
                throw new ConfigurationException("A value is expected after: " + args[inx]);
            }
            if (!ServerConfig.setParamFromString(name, value = args[++inx])) {
                unknownArgs.add(name);
            }
            ++inx;
        }
        if (!unknownArgs.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (String arg : unknownArgs) {
                b.append("\"" + arg + "\" ");
            }
            throw new ConfigurationException("Couldn't parse argument(s): " + b.toString());
        }
    }

    private static void setParams(Map<String, ?> map) {
        for (String name : map.keySet()) {
            try {
                Object value = map.get(name);
                if (value instanceof List) {
                    ServerConfig.setCollectionParam(name, (List)value);
                    continue;
                }
                ServerConfig.setParam(name, value);
            }
            catch (ConfigurationException e) {
                logger.warn(String.valueOf(e.getMessage()) + " -- Ignoring.");
            }
        }
    }

    private static boolean setParamFromString(String name, String value) throws ConfigurationException {
        try {
            Field field = config.getClass().getDeclaredField(name);
            String fieldType = field.getType().toString();
            if (fieldType.compareToIgnoreCase("int") == 0) {
                field.set(config, Integer.parseInt(value));
            } else if (fieldType.compareToIgnoreCase("boolean") == 0) {
                field.set(config, Boolean.parseBoolean(value));
            } else if (fieldType.endsWith("List")) {
                ServerConfig.setCollectionParam(name, Arrays.asList(value.split(",")));
            } else {
                field.set(config, value);
            }
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Couldn't parse parameter: " + value);
        }
    }

    private static void setParam(String name, Object value) throws ConfigurationException {
        try {
            Field field = config.getClass().getDeclaredField(name);
            field.set(config, value);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new ConfigurationException("Unknown configuration parameter: " + name);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Couldn't parse parameter: " + value);
        }
    }

    private static void setCollectionParam(String name, List<?> values) throws ConfigurationException {
        block4: {
            try {
                Field field = config.getClass().getDeclaredField(name);
                Class<?> fieldClass = field.getType();
                if (Map.class.isAssignableFrom(fieldClass)) {
                    ServerConfig.setMapParam(field, values);
                    break block4;
                }
                if (List.class.isAssignableFrom(fieldClass)) {
                    ServerConfig.setListParam(field, values);
                    break block4;
                }
                throw new ConfigurationException("Invalid value type for parameter: " + name);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new ConfigurationException("Unknown configuration parameter: " + name);
            }
        }
    }

    private static void setListParam(Field field, List<?> values) {
        try {
            Class<?> fieldClass = field.getType();
            Method clearMethod = fieldClass.getMethod("clear", new Class[0]);
            clearMethod.invoke(field.get(config), new Object[0]);
            Method addMethod = fieldClass.getMethod("add", Object.class);
            for (Object subParam : values) {
                if (subParam instanceof String) {
                    addMethod.invoke(field.get(config), subParam);
                    continue;
                }
                throw new RuntimeException("Unexpected parameter type for '" + field.getName() + ":" + subParam);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error setting configuration parameter '" + field.getName() + "'", e);
        }
    }

    private static void setMapParam(Field field, List<?> values) {
        try {
            Class<?> fieldClass = field.getType();
            Method addMethod = fieldClass.getMethod("put", Object.class, Object.class);
            for (Object subParam : values) {
                if (subParam instanceof Map) {
                    Map map = (Map)subParam;
                    for (String key : map.keySet()) {
                        Object value = map.get(key);
                        if (value instanceof List) {
                            value = ((List)value).get(0);
                        }
                        addMethod.invoke(field.get(config), key, value);
                    }
                    continue;
                }
                throw new RuntimeException("Unexpected collection parameter type for '" + field.getName() + ":" + subParam);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error setting configuration parameter '" + field.getName() + "'", e);
        }
    }
}

