/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.core;

import com.dell.doradus.common.Utils;
import java.util.Arrays;

public final class ObjectID
implements Comparable<ObjectID> {
    public static final ObjectID EMPTY = new ObjectID(new byte[0], IDFormat.UNKNOWN);
    private final IDFormat m_format;
    private final byte[] m_value;

    public ObjectID(byte[] value, IDFormat format) {
        this.m_value = value;
        this.m_format = format;
    }

    public ObjectID(String id, IDFormat format) {
        this.m_format = format;
        if (id == null || id.length() == 0) {
            this.m_value = new byte[0];
            return;
        }
        switch (this.m_format) {
            case UFT8: {
                this.m_value = Utils.toBytes((String)id);
                break;
            }
            case BASE64: {
                this.m_value = Utils.base64ToBinary((String)id);
                break;
            }
            default: {
                throw new RuntimeException("Unknown ID format: " + this.m_format.toString());
            }
        }
    }

    public byte[] bytes() {
        return this.m_value;
    }

    public IDFormat format() {
        return this.m_format;
    }

    @Override
    public int compareTo(ObjectID other) {
        int len = this.m_value.length < other.m_value.length ? this.m_value.length : other.m_value.length;
        int i = 0;
        while (i < len) {
            if (this.m_value[i] != other.m_value[i]) {
                return (char)this.m_value[i] - (char)other.m_value[i];
            }
            ++i;
        }
        return this.m_value.length - other.m_value.length;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ObjectID)) {
            return false;
        }
        return Arrays.equals(this.m_value, ((ObjectID)other).m_value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_value);
    }

    public String toString() {
        if (this.m_value == null || this.m_value.length == 0) {
            return "";
        }
        switch (this.m_format) {
            case UFT8: {
                return Utils.toString((byte[])this.m_value);
            }
            case BASE64: {
                return Utils.base64FromBinary((byte[])this.m_value);
            }
        }
        throw new RuntimeException("Unknown ID format: " + this.m_format.toString());
    }

    public static enum IDFormat {
        UNKNOWN,
        UFT8,
        BASE64;

    }
}

