/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.core;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Random;

public class IDGenerator {
    private static final byte[] MAC = IDGenerator.chooseMACAddress();
    private static final Object LOCK = new Object();
    private static long LAST_TIMESTAMP;
    private static final byte[] TIMESTAMP_BUFFER;
    private static short LAST_SEQUENCE;

    static {
        TIMESTAMP_BUFFER = new byte[7];
    }

    private IDGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] nextID() {
        byte[] ID = new byte[15];
        Object object = LOCK;
        synchronized (object) {
            long timestamp = System.currentTimeMillis();
            if (timestamp != LAST_TIMESTAMP) {
                LAST_TIMESTAMP = timestamp;
                LAST_SEQUENCE = 0;
                IDGenerator.TIMESTAMP_BUFFER[0] = (byte)(timestamp >>> 48);
                IDGenerator.TIMESTAMP_BUFFER[1] = (byte)(timestamp >>> 40);
                IDGenerator.TIMESTAMP_BUFFER[2] = (byte)(timestamp >>> 32);
                IDGenerator.TIMESTAMP_BUFFER[3] = (byte)(timestamp >>> 24);
                IDGenerator.TIMESTAMP_BUFFER[4] = (byte)(timestamp >>> 16);
                IDGenerator.TIMESTAMP_BUFFER[5] = (byte)(timestamp >>> 8);
                IDGenerator.TIMESTAMP_BUFFER[6] = (byte)(timestamp >>> 0);
            } else if ((LAST_SEQUENCE = (short)(LAST_SEQUENCE + 1)) == 0) {
                throw new RuntimeException("Same ID generated in a single milliscond!");
            }
            ByteBuffer bb = ByteBuffer.wrap(ID);
            bb.put(TIMESTAMP_BUFFER);
            bb.put(MAC);
            bb.putShort(LAST_SEQUENCE);
        }
        return ID;
    }

    private static byte[] chooseMACAddress() {
        byte[] result = new byte[6];
        boolean bFound = false;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (!bFound && ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                try {
                    byte[] hwAddress = iface.getHardwareAddress();
                    if (hwAddress == null) continue;
                    int copyBytes = Math.min(result.length, hwAddress.length);
                    int index = 0;
                    while (index < copyBytes) {
                        result[index] = hwAddress[index];
                        ++index;
                    }
                    bFound = true;
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (!bFound) {
            new Random().nextBytes(result);
        }
        return result;
    }
}

