/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.core;

import com.dell.doradus.common.ConfigurationException;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.tenant.TenantService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DoradusServer {
    private static final DoradusServer INSTANCE = new DoradusServer();
    private boolean m_bInitialized;
    private boolean m_bRunning;
    private final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private static final String[] REQUIRED_SERVICES = new String[]{DBService.class.getName(), SchemaService.class.getName(), TenantService.class.getName()};
    private final List<Service> m_initializedServices = new ArrayList<Service>();
    private final List<StorageService> m_storageServices = new ArrayList<StorageService>();
    private final List<Service> m_startedServices = new ArrayList<Service>();
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("GET /_dump com.dell.doradus.core.TheadDumpCmd", true), new RESTCommand("GET /_logs?{params} com.dell.doradus.core.LogDumpCmd", true));

    public static DoradusServer instance() {
        return INSTANCE;
    }

    public static void main(String[] args) {
        try {
            DoradusServer.instance().initStandAlone(args);
            DoradusServer.instance().start();
            DoradusServer.instance().waitForShutdown();
        }
        catch (Throwable e) {
            DoradusServer.instance().m_logger.error("Abnormal shutdown", e);
            System.exit(1);
        }
    }

    public static void startServer(String[] args) {
        DoradusServer.main(args);
    }

    public static void startEmbedded(String[] args, String[] services) {
        DoradusServer.instance().initEmbedded(args, services);
        DoradusServer.instance().start();
    }

    public static void stopServer(String[] args) {
        DoradusServer.instance().stop();
        System.exit(0);
    }

    public static void shutDown() {
        DoradusServer.instance().stop();
    }

    public String getDefaultStorageService() {
        assert (this.m_storageServices.size() > 0);
        return this.m_storageServices.get(0).getClass().getSimpleName();
    }

    public StorageService findStorageService(String serviceName) {
        Utils.require((boolean)this.m_bInitialized, (String)"DoradusService has not yet initialized");
        for (StorageService service : this.m_storageServices) {
            if (!service.getClass().getSimpleName().equals(serviceName)) continue;
            return service;
        }
        return null;
    }

    private DoradusServer() {
    }

    private void addConfiguredStorageServices(Set<String> serviceSet) {
        List<String> ssList = ServerConfig.getInstance().storage_services;
        if (ssList != null) {
            serviceSet.addAll(ssList);
        }
    }

    private void addDefaultServices(Set<String> serviceSet) {
        List<String> defaultServices = ServerConfig.getInstance().default_services;
        if (defaultServices != null) {
            serviceSet.addAll(defaultServices);
        }
    }

    private void hookShutdownEvent() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DoradusServer.instance().stop();
            }
        });
    }

    private void initEmbedded(String[] args, String[] services) {
        if (this.m_bInitialized) {
            this.m_logger.warn("initEmbedded: Already initialized -- ignoring");
            return;
        }
        this.m_logger.info("Initializing embedded mode");
        this.initConfig(args);
        this.initEmbeddedServices(services);
        RESTService.instance().registerGlobalCommands(REST_RULES);
        this.m_bInitialized = true;
    }

    private void initEmbeddedServices(String[] requestedServices) {
        LinkedHashSet<String> serviceSet = new LinkedHashSet<String>();
        if (requestedServices != null) {
            serviceSet.addAll(Arrays.asList(requestedServices));
        }
        this.addRequiredServices(serviceSet);
        this.initServices(serviceSet);
    }

    private void initStandAlone(String[] args) {
        if (this.m_bInitialized) {
            this.m_logger.warn("initStandAlone: Already initialized -- ignoring");
            return;
        }
        this.m_logger.info("Initializing standalone mode");
        this.initConfig(args);
        this.initStandaAloneServices();
        RESTService.instance().registerGlobalCommands(REST_RULES);
        this.m_bInitialized = true;
    }

    private void initStandaAloneServices() {
        LinkedHashSet<String> serviceSet = new LinkedHashSet<String>();
        this.addDefaultServices(serviceSet);
        this.addRequiredServices(serviceSet);
        this.addConfiguredStorageServices(serviceSet);
        this.initServices(serviceSet);
    }

    private void initConfig(String[] args) {
        try {
            ServerConfig.load(args);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to initialize server configuration", e);
        }
    }

    private void initServices(Set<String> serviceSet) {
        for (String serviceName : serviceSet) {
            Service service = this.initService(serviceName);
            this.m_initializedServices.add(service);
            if (!(service instanceof StorageService)) continue;
            this.m_storageServices.add((StorageService)service);
        }
        if (this.m_storageServices.size() == 0) {
            throw new RuntimeException("No storage services were configured");
        }
    }

    private Service initService(String serviceName) {
        this.m_logger.debug("Initializing service: " + serviceName);
        try {
            Class<?> serviceClass = Class.forName(serviceName);
            Method instanceMethod = serviceClass.getMethod("instance", null);
            Service instance = (Service)instanceMethod.invoke(null, null);
            instance.initialize();
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing service: " + serviceName, e);
        }
    }

    private void addRequiredServices(Set<String> serviceSet) {
        serviceSet.addAll(Arrays.asList(REQUIRED_SERVICES));
    }

    private void start() {
        if (this.m_bRunning) {
            this.m_logger.warn("start: Already started -- ignoring");
            return;
        }
        Locale.setDefault(Locale.ROOT);
        this.m_logger.info("Doradus Version: {}", (Object)this.getClass().getPackage().getImplementationVersion());
        this.hookShutdownEvent();
        this.startServices();
        this.m_bRunning = true;
    }

    private void startServices() {
        this.m_logger.info("Starting services: {}", (Object)this.simpleServiceNames(this.m_initializedServices));
        for (Service service : this.m_initializedServices) {
            this.m_logger.debug("Starting service: " + service.getClass().getSimpleName());
            service.start();
            this.m_startedServices.add(service);
        }
    }

    private String simpleServiceNames(Collection<Service> services) {
        StringBuilder buffer = new StringBuilder();
        for (Service service : services) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(service.getClass().getSimpleName());
        }
        return buffer.toString();
    }

    private void stopServices() {
        this.m_logger.debug("Stopping all services");
        ListIterator<Service> iter = this.m_startedServices.listIterator(this.m_startedServices.size());
        while (iter.hasPrevious()) {
            Service service = iter.previous();
            this.m_logger.debug("Stopping service: " + service.getClass().getSimpleName());
            service.stop();
            iter.remove();
        }
        this.m_initializedServices.clear();
        this.m_storageServices.clear();
    }

    private void stop() {
        if (this.m_bRunning) {
            DoradusServer.instance().m_logger.info("Doradus Server shutting down");
            this.stopServices();
            ServerConfig.unload();
            this.m_bRunning = false;
            this.m_bInitialized = false;
        }
    }

    private void waitForShutdown() {
        this.m_logger.info("Main thread waiting for shutdown notice");
        DoradusServer doradusServer = this;
        synchronized (doradusServer) {
            while (true) {
                try {
                    while (true) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

