/*
 * Decompiled with CFR 0.152.
 */
package com.deimian86.timelapse;

import android.content.Context;
import android.content.res.Configuration;
import android.support.annotation.NonNull;
import com.deimian86.timelapse.R;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeLapse {
    private static volatile TimeLapse singleton = null;
    private final Context context;
    private Date startDate;
    private Locale locale;

    private TimeLapse(Builder builder) {
        this.context = builder.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeLapse with(Context mContext) {
        if (singleton != null) return singleton;
        Class<TimeLapse> clazz = TimeLapse.class;
        synchronized (TimeLapse.class) {
            if (singleton != null) return singleton;
            if (mContext == null) {
                throw new IllegalStateException("context == null");
            }
            singleton = new Builder(mContext).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public TimeLapse date(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public TimeLapse locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public String getLapse() {
        String mString = "";
        SimpleDateFormat txtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date actualDate = new Date();
        txtFormat.format(actualDate);
        long diff = actualDate.getTime() - this.startDate.getTime();
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        if (diffDays == 0L) {
            if (diffHours == 0L) {
                mString = diffMinutes < 10L ? TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_moments_ago, diffMinutes) : TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_minutes_ago, diffMinutes);
            } else if (diffHours == 1L) {
                mString = TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_hour_ago, diffHours);
            } else if (diffHours > 1L) {
                mString = TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_hours_ago, diffHours);
            }
        } else if (diffDays == 1L) {
            mString = TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_day_ago, diffDays);
        } else if (diffDays > 1L && diffDays < 7L) {
            mString = TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_days_ago, diffDays);
        } else if (diffDays == 7L) {
            mString = TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_week_ago, diffDays);
        } else if (diffDays > 7L && diffDays < 14L) {
            mString = TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_days_ago, diffDays);
        } else if (diffDays == 14L) {
            mString = TimeLapse.getLocaleStringResource(this.context, this.locale, R.string.lapse_weeks_ago, 2L);
        } else if (diffDays > 14L) {
            SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
            mString = formato.format(this.startDate);
        }
        return mString;
    }

    private static String getLocaleStringResource(Context context, Locale requestedLocale, int resourceId, long param) {
        Configuration config = new Configuration(context.getResources().getConfiguration());
        config.setLocale(requestedLocale);
        String result = context.createConfigurationContext(config).getString(resourceId, new Object[]{param});
        return result;
    }

    private static class Builder {
        private final Context context;

        private Builder(@NonNull Context context) {
            this.context = context.getApplicationContext();
        }

        private TimeLapse build() {
            return new TimeLapse(this);
        }
    }
}

