/*
 * Decompiled with CFR 0.152.
 */
package com.deimian86.timelapse;

import android.content.Context;
import android.content.res.Configuration;
import com.deimian86.timelapse.R;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeLapse {
    public String getLapse(Context context, Date startDate, Locale locale) {
        String mString = "";
        SimpleDateFormat txtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date actualDate = new Date();
        txtFormat.format(actualDate);
        long diff = actualDate.getTime() - startDate.getTime();
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        if (diffDays == 0L) {
            if (diffHours == 0L) {
                mString = diffMinutes < 10L ? TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_moments_ago, diffMinutes) : TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_minutes_ago, diffMinutes);
            } else if (diffHours == 1L) {
                mString = TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_hour_ago, diffHours);
            } else if (diffHours > 1L) {
                mString = TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_hours_ago, diffHours);
            }
        } else if (diffDays == 1L) {
            mString = TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_day_ago, diffDays);
        } else if (diffDays > 1L && diffDays < 7L) {
            mString = TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_days_ago, diffDays);
        } else if (diffDays == 7L) {
            mString = TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_week_ago, diffDays);
        } else if (diffDays > 7L && diffDays < 14L) {
            mString = TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_days_ago, diffDays);
        } else if (diffDays == 14L) {
            mString = TimeLapse.getLocaleStringResource(context, locale, R.string.lapse_weeks_ago, 2L);
        } else if (diffDays > 14L) {
            SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
            mString = formato.format(startDate);
        }
        return mString;
    }

    private static String getLocaleStringResource(Context context, Locale requestedLocale, int resourceId, long param) {
        Configuration config = new Configuration(context.getResources().getConfiguration());
        config.setLocale(requestedLocale);
        String result = context.createConfigurationContext(config).getString(resourceId, new Object[]{param});
        return result;
    }
}

