/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world.edit;

import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.world.edit.AbstractRegionFormat;
import com.degoos.wetsponge.world.edit.WSRegionFormat;
import java.io.File;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum WetRegionFormat {
    WETSPONGE(new AbstractRegionFormat("WETSPONGE", new String[]{"ws", "wet"}){});

    private static final ConcurrentHashMap aliasMap;
    private WSRegionFormat format;

    private WetRegionFormat() {
    }

    private WetRegionFormat(WSRegionFormat format) {
        this.format = format;
    }

    public Set<String> getAliases() {
        return this.format.getAliases();
    }

    public String getName() {
        return this.format.getName();
    }

    public boolean isFormat(File file) {
        return this.format.isFormat(file);
    }

    public static WetRegionFormat findByAlias(String alias) {
        Validate.notNull(alias);
        return (WetRegionFormat)((Object)aliasMap.get(alias.toLowerCase().trim()));
    }

    public static WetRegionFormat findByFile(File file) {
        WetRegionFormat format;
        Validate.notNull(file);
        Iterator var1 = EnumSet.allOf(WetRegionFormat.class).iterator();
        do {
            if (var1.hasNext()) continue;
            return null;
        } while (!(format = (WetRegionFormat)((Object)var1.next())).isFormat(file));
        return format;
    }

    public static WetRegionFormat addFormat(WSRegionFormat instance) {
        WetRegionFormat newEnum = ReflectionUtils.addEnum(WetRegionFormat.class, instance.getName());
        newEnum.format = instance;
        for (String alias : newEnum.getAliases()) {
            aliasMap.put(alias.toLowerCase().trim(), newEnum);
        }
        return newEnum;
    }

    public static Class<?> inject() {
        return WetRegionFormat.class;
    }

    static {
        aliasMap = new ConcurrentHashMap(8, 0.9f, 1);
        for (WetRegionFormat emum : WetRegionFormat.values()) {
            for (String alias : emum.getAliases()) {
                aliasMap.put(alias, emum);
            }
        }
    }
}

