/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world.edit;

import com.degoos.wetsponge.SpigotWetSponge;
import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.play.server.WSSPacketBlockChange;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.degoos.wetsponge.world.SpigotChunk;
import com.degoos.wetsponge.world.WSWorld;
import com.degoos.wetsponge.world.edit.WSWorldQueue;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpigotWorldQueue
implements WSWorldQueue {
    private Map<Vector2i, Map<Vector3i, WSBlockType>> types;
    private WSWorld world;

    public SpigotWorldQueue(WSWorld world) {
        this.world = world;
        this.types = new HashMap<Vector2i, Map<Vector3i, WSBlockType>>();
    }

    @Override
    public void setBlock(Vector3i position, WSBlockType blockType) {
        if (position.getY() < 0 || position.getY() > this.world.getProperties().getMaxHeight()) {
            return;
        }
        Vector2i chunk = new Vector2i(position.getX() >> 4, position.getZ() >> 4);
        Map<Vector3i, WSBlockType> chunkMap = this.types.get(chunk);
        if (chunkMap == null) {
            chunkMap = new HashMap<Vector3i, WSBlockType>();
        }
        chunkMap.put(position, blockType);
        this.types.put(chunk, chunkMap);
    }

    @Override
    public void flush(final boolean sendPacket, final boolean async) {
        if (Thread.currentThread() != WetSponge.getMainThread()) {
            new BukkitRunnable(){

                public void run() {
                    SpigotWorldQueue.this.flush(sendPacket, async);
                }
            }.runTaskLater((Plugin)SpigotWetSponge.getInstance(), 0L);
            return;
        }
        try {
            Class<?> chunkClass = NMSUtils.getNMSClass("Chunk");
            Class<?> blockPositionClass = NMSUtils.getNMSClass("BlockPosition");
            Class<?> iBlockDataClass = NMSUtils.getNMSClass("IBlockData");
            Method setBlockState = chunkClass.getMethod("a", blockPositionClass, iBlockDataClass);
            HashMap chunks = new HashMap();
            this.types.keySet().forEach(vector -> {
                try {
                    SpigotChunk chunk = this.world.loadChunk(vector.getX(), vector.getY(), true).orElse(null);
                    chunk.setCanBeUnloaded(false);
                    chunks.put(vector, chunk);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            Thread thread = new Thread(() -> {
                if (sendPacket) {
                    Set<WSPlayer> players = this.world.getPlayers();
                    this.types.forEach((vector2i, blocks) -> {
                        try {
                            SpigotChunk chunk = (SpigotChunk)chunks.get(vector2i);
                            blocks.forEach((vector3i, blockType) -> {
                                try {
                                    setBlockState.invoke(chunk.getBukkitHandled(), SpigotHandledUtils.getBlockPosition(vector3i), SpigotHandledUtils.getBlockState(blockType));
                                    WSSPacketBlockChange packet = WSSPacketBlockChange.of(blockType, vector3i);
                                    players.forEach(player -> player.sendPacket(packet));
                                }
                                catch (Exception ex) {
                                    InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
                                }
                            });
                            chunk.setCanBeUnloaded(true);
                        }
                        catch (Exception ex) {
                            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
                        }
                    });
                    return;
                }
                this.types.forEach((vector2i, blocks) -> {
                    try {
                        SpigotChunk chunk = (SpigotChunk)chunks.get(vector2i);
                        blocks.forEach((vector3i, blockType) -> {
                            try {
                                setBlockState.invoke(chunk.getBukkitHandled(), SpigotHandledUtils.getBlockPosition(vector3i), SpigotHandledUtils.getBlockState(blockType));
                            }
                            catch (Exception ex) {
                                InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
                            }
                        });
                        chunk.setCanBeUnloaded(true);
                    }
                    catch (Exception ex) {
                        InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
                    }
                });
            });
            if (async) {
                thread.start();
            } else {
                thread.run();
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was flushing a queue!");
        }
    }
}

