/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.enums.EnumDifficulty;
import com.degoos.wetsponge.enums.EnumGameMode;
import com.flowpowered.math.vector.Vector3i;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public interface WSWorldProperties {
    public boolean isInitialized();

    public String getWorldName();

    public UUID getUniqueId();

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean loadOnStartup();

    public void setLoadOnStartup(boolean var1);

    public boolean doesKeepSpawnLoaded();

    public void setKeepSpawnLoaded(boolean var1);

    public boolean doesGenerateSpawnOnLoad();

    public void setGenerateSpawnOnLoad(boolean var1);

    public Vector3i getSpawnPosition();

    public void setSpawnPosition(Vector3i var1);

    public long getSeed();

    public void setSeed(long var1);

    public long getTotalTime();

    public long getWorldTime();

    public void setWorldTime(long var1);

    public boolean isPVPEnabled();

    public void setPVPEnabled(boolean var1);

    public boolean isRaining();

    public void setRaining(boolean var1);

    public int getRainTime();

    public void setRainTime(int var1);

    public boolean isThundering();

    public void setThundering(boolean var1);

    public int getThunderTime();

    public void setThunderTime(int var1);

    public EnumGameMode getGameMode();

    public void setGameMode(EnumGameMode var1);

    public boolean usesMapFeatures();

    public void setMapFeaturesEnabled(boolean var1);

    public boolean isHardcore();

    public void setHardcore(boolean var1);

    public boolean areCommandsAllowed();

    public void setCommandsAllowed(boolean var1);

    public EnumDifficulty getDifficulty();

    public void setDifficulty(EnumDifficulty var1);

    public boolean doesGenerateBonusChest();

    public Optional<String> getGameRule(String var1);

    public Map<String, String> getGameRules();

    public void setGameRule(String var1, String var2);

    public boolean removeGameRule(String var1);

    public int getMaxHeight();

    default public void apply(WSWorldProperties properties) {
        this.setEnabled(properties.isEnabled());
        this.setLoadOnStartup(properties.loadOnStartup());
        this.setKeepSpawnLoaded(properties.doesKeepSpawnLoaded());
        this.setGenerateSpawnOnLoad(properties.doesGenerateSpawnOnLoad());
        this.setSpawnPosition(properties.getSpawnPosition());
        this.setSeed(properties.getSeed());
        this.setWorldTime(properties.getWorldTime());
        this.setPVPEnabled(properties.isPVPEnabled());
        this.setRaining(properties.isRaining());
        this.setRainTime(properties.getRainTime());
        this.setThundering(properties.isThundering());
        this.setThunderTime(properties.getThunderTime());
        this.setGameMode(properties.getGameMode());
        this.setMapFeaturesEnabled(properties.usesMapFeatures());
        this.setHardcore(properties.isHardcore());
        this.setCommandsAllowed(properties.areCommandsAllowed());
        this.setDifficulty(properties.getDifficulty());
        this.getGameRules().values().forEach(this::removeGameRule);
        properties.getGameRules().forEach(this::setGameRule);
    }
}

