/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBiomeType;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.enums.EnumMapBaseColor;
import com.degoos.wetsponge.map.WSMapView;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.world.WSChunk;
import com.degoos.wetsponge.world.WSExplosion;
import com.degoos.wetsponge.world.WSWorldBorder;
import com.degoos.wetsponge.world.WSWorldProperties;
import com.degoos.wetsponge.world.generation.WSWorldGenerator;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public interface WSWorld {
    public String getName();

    public Set<WSEntity> getEntities();

    public Set<WSPlayer> getPlayers();

    public UUID getUniqueId();

    public <T extends WSEntity> Optional<T> spawnEntity(Class<T> var1, Vector3d var2);

    public Optional<WSEntity> spawnEntity(EnumEntityType var1, Vector3d var2);

    public boolean spawnEntity(WSEntity var1);

    public <T extends WSEntity> Optional<T> createEntity(Class<T> var1, Vector3d var2);

    public Optional<WSEntity> createEntity(EnumEntityType var1, Vector3d var2);

    public Optional<WSHuman> createNPC(WSGameProfile var1, Vector3d var2);

    public WSWorldProperties getProperties();

    public WSWorldGenerator getGenerator();

    public Optional<WSChunk> getChunk(int var1, int var2);

    public Optional<WSChunk> getChunkAtLocation(int var1, int var2);

    public Optional<WSChunk> loadChunk(int var1, int var2, boolean var3);

    public Optional<WSChunk> loadChunkAtLocation(int var1, int var2, boolean var3);

    public Set<WSChunk> getLoadedChunks();

    public EnumBiomeType getBiome(int var1, int var2, int var3);

    public void setBiome(int var1, int var2, int var3, EnumBiomeType var4);

    public boolean isAutoSave();

    public void setAutoSave(boolean var1);

    public void save();

    public void flushUnloadedChunksQueue();

    public void shutdownAllChunks();

    public boolean canBeSaved();

    public void setCanBeSaved(boolean var1);

    public void saveAllChunks();

    public WSBlockType getBlockType(Vector3i var1);

    public WSBlockType getBlockType(int var1, int var2, int var3);

    public Map<Vector3i, WSBlockType> getBlockTypesInArea(Vector3i var1, Vector3i var2);

    public Map<Vector3i, WSBlockType> getBlockTypesInArea(Vector3i var1, Vector3i var2, boolean var3);

    public Map<Vector2i, EnumMapBaseColor> getMapColors(Vector3i var1, Vector3i var2);

    public void triggerExplosion(WSExplosion var1);

    public WSWorldBorder getWorldBorder();

    public Map<Integer, WSMapView> getMapViews();

    public Optional<WSMapView> getMapView(int var1);

    public void putMapView(int var1, WSMapView var2);

    public void removeMapView(int var1);

    public void clearMapViews();

    public File getWorldFolder();

    public Object getChunkProvider();

    public Object getHandled();
}

