/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.bridge.world.BridgeLocation;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBiomeType;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.Collection;

public interface WSLocation
extends Cloneable {
    public static WSLocation of(String worldName, double x, double y, double z, float yaw, float pitch) {
        return BridgeLocation.of(worldName, x, y, z, yaw, pitch);
    }

    public static WSLocation of(String worldName, double x, double y, double z) {
        return WSLocation.of(worldName, x, y, z, 0.0f, 0.0f);
    }

    public static WSLocation of(String worldName, Vector3d position) {
        return WSLocation.of(worldName, position.getX(), position.getY(), position.getZ(), 0.0f, 0.0f);
    }

    public static WSLocation of(String worldName, Vector3i position) {
        return WSLocation.of(worldName, (double)position.getX(), (double)position.getY(), (double)position.getZ(), 0.0f, 0.0f);
    }

    public static WSLocation of(WSWorld world, double x, double y, double z, float yaw, float pitch) {
        return WSLocation.of(world.getName(), x, y, z, yaw, pitch);
    }

    public static WSLocation of(WSWorld world, double x, double y, double z) {
        return WSLocation.of(world, x, y, z, 0.0f, 0.0f);
    }

    public static WSLocation of(WSWorld world, Vector3d position) {
        return WSLocation.of(world, position.getX(), position.getY(), position.getZ(), 0.0f, 0.0f);
    }

    public static WSLocation of(WSWorld world, Vector3i position) {
        return WSLocation.of(world, (double)position.getX(), (double)position.getY(), (double)position.getZ(), 0.0f, 0.0f);
    }

    public static WSLocation of(String string) {
        return BridgeLocation.of(string);
    }

    public String toString();

    public String getWorldName();

    public WSLocation setWorldName(String var1);

    public WSWorld getWorld();

    public WSLocation setWorld(WSWorld var1);

    public WSBlock getBlock();

    public WSLocation updateWorld();

    public double getX();

    public WSLocation setX(double var1);

    public double getY();

    public WSLocation setY(double var1);

    public double getZ();

    public WSLocation setZ(double var1);

    public float getYaw();

    public WSLocation setYaw(float var1);

    public float getPitch();

    public WSLocation setPitch(float var1);

    public Vector2f getRotation();

    public WSLocation setRotation(Vector2f var1);

    public int getBlockX();

    public int getBlockY();

    public int getBlockZ();

    public double distance(WSLocation var1);

    public double distance(double var1, double var3, double var5);

    public double distance(Vector3d var1);

    public WSLocation add(double var1, double var3, double var5);

    public WSLocation add(Vector3d var1);

    public WSLocation clone();

    public WSLocation getBlockLocation();

    public EnumBiomeType getBiome();

    public void setBiome(EnumBiomeType var1);

    public Collection<WSEntity> getNearbyEntities(Vector3d var1);

    public Collection<WSEntity> getNearbyEntities(double var1);

    public <T extends WSEntity> Collection<T> getNearbyEntities(Vector3d var1, Class<T> var2);

    public <T extends WSEntity> Collection<T> getNearbyEntities(double var1, Class<T> var3);

    public Collection<WSPlayer> getNearbyPlayers(Vector3d var1);

    public Collection<WSPlayer> getNearbyPlayers(double var1);

    public int getHighestY();

    public WSLocation updateSign(String[] var1);

    public boolean equalsBlock(Object var1);

    public Vector3d getFacingDirection();

    public Vector3d toVector3d();

    public Vector3i toVector3i();

    public Object getHandledWorld();
}

