/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.enums.EnumDifficulty;
import com.degoos.wetsponge.enums.EnumGameMode;
import com.degoos.wetsponge.world.WSWorldProperties;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class UnlinkedWorldProperties
implements WSWorldProperties {
    private boolean initialized;
    private boolean enabled;
    private boolean loadOnStartup;
    private boolean keepSpawnLoaded;
    private boolean generateSpawnOnLoad;
    private boolean pvpEnabled;
    private boolean raining;
    private boolean thundering;
    private boolean mapFeaturesEnabled;
    private boolean hardcore;
    private boolean commandsAllowed;
    private boolean generateBonusChest;
    private String worldName;
    private UUID uniqueId;
    private Vector3i spawnPosition;
    private long seed;
    private long totalTime;
    private long worldTime;
    private long worldBorderTimeRemaining;
    private int rainTime;
    private int thunderTime;
    private int worldBorderWarningTime;
    private int worldBorderWarningDistance;
    private EnumGameMode gameMode;
    private EnumDifficulty difficulty;
    private Vector3d worldBorderCenter;
    private double worldBorderDiameter;
    private double worldBorderTargetDiameter;
    private double worldBorderDamageThreshold;
    private double worldBolderDamageAmount;
    private Map<String, String> gameRules;
    private int maxHeight;

    public UnlinkedWorldProperties(String worldName) {
        this.worldName = worldName;
        this.uniqueId = null;
        this.spawnPosition = new Vector3i(0, 0, 0);
        this.gameMode = EnumGameMode.SURVIVAL;
        this.difficulty = EnumDifficulty.NORMAL;
        this.worldBorderCenter = new Vector3d(0.0f, 0.0f, 0.0f);
        this.worldBorderDiameter = 6.0E7;
        this.gameRules = new HashMap<String, String>();
        this.maxHeight = 255;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean loadOnStartup() {
        return this.loadOnStartup;
    }

    @Override
    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    @Override
    public boolean doesKeepSpawnLoaded() {
        return this.keepSpawnLoaded;
    }

    @Override
    public void setKeepSpawnLoaded(boolean keepSpawnLoaded) {
        this.keepSpawnLoaded = keepSpawnLoaded;
    }

    @Override
    public boolean doesGenerateSpawnOnLoad() {
        return this.generateSpawnOnLoad;
    }

    @Override
    public void setGenerateSpawnOnLoad(boolean generateSpawnOnLoad) {
        this.generateSpawnOnLoad = generateSpawnOnLoad;
    }

    @Override
    public Vector3i getSpawnPosition() {
        return this.spawnPosition;
    }

    @Override
    public void setSpawnPosition(Vector3i spawnPosition) {
        this.spawnPosition = spawnPosition;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public long getWorldTime() {
        return this.worldTime;
    }

    @Override
    public void setWorldTime(long worldTime) {
        this.worldTime = worldTime;
    }

    @Override
    public boolean isPVPEnabled() {
        return this.pvpEnabled;
    }

    @Override
    public void setPVPEnabled(boolean pvpEnabled) {
        this.pvpEnabled = pvpEnabled;
    }

    @Override
    public boolean isRaining() {
        return this.raining;
    }

    @Override
    public void setRaining(boolean raining) {
        this.raining = raining;
    }

    @Override
    public int getRainTime() {
        return this.rainTime;
    }

    @Override
    public void setRainTime(int rainTime) {
        this.rainTime = rainTime;
    }

    @Override
    public boolean isThundering() {
        return this.thundering;
    }

    @Override
    public void setThundering(boolean thundering) {
        this.thundering = thundering;
    }

    @Override
    public int getThunderTime() {
        return this.thunderTime;
    }

    @Override
    public void setThunderTime(int thunderTime) {
        this.thunderTime = thunderTime;
    }

    @Override
    public EnumGameMode getGameMode() {
        return this.gameMode;
    }

    @Override
    public void setGameMode(EnumGameMode gameMode) {
        this.gameMode = gameMode;
    }

    @Override
    public boolean usesMapFeatures() {
        return this.mapFeaturesEnabled;
    }

    @Override
    public void setMapFeaturesEnabled(boolean mapFeaturesEnabled) {
        this.mapFeaturesEnabled = mapFeaturesEnabled;
    }

    @Override
    public boolean isHardcore() {
        return this.hardcore;
    }

    @Override
    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    @Override
    public boolean areCommandsAllowed() {
        return this.commandsAllowed;
    }

    @Override
    public void setCommandsAllowed(boolean commandsAllowed) {
        this.commandsAllowed = commandsAllowed;
    }

    @Override
    public EnumDifficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public void setDifficulty(EnumDifficulty difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public boolean doesGenerateBonusChest() {
        return this.generateBonusChest;
    }

    @Override
    public Optional<String> getGameRule(String name) {
        return this.gameRules.keySet().stream().filter(gameRule -> gameRule.equalsIgnoreCase(name)).map(gameRule -> this.gameRules.get(gameRule)).findAny();
    }

    @Override
    public Map<String, String> getGameRules() {
        return this.gameRules;
    }

    @Override
    public void setGameRule(String name, String value) {
        this.gameRules.put(name, value);
    }

    @Override
    public boolean removeGameRule(String name) {
        this.gameRules.remove(name);
        return true;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }
}

