/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.entity.explosive.WSExplosive;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.world.WSExplosion;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import java.util.Optional;
import javax.annotation.Nullable;

public class SpigotExplosion
implements WSExplosion {
    private WSExplosive explosive;
    private WSLocation location;
    private float radius;
    private boolean canCauseFire;
    private boolean shouldPlaySmoke;
    private boolean shouldBreakBlocks;
    private boolean shouldDamageEntities;

    public SpigotExplosion(WSExplosive explosive, WSLocation location, float radius, boolean canCauseFire, boolean shouldPlaySmoke, boolean shouldBreakBlocks, boolean shouldDamageEntities) {
        Validate.notNull(location, "Location cannot be null!");
        this.explosive = explosive;
        this.location = location;
        this.radius = radius;
        this.canCauseFire = canCauseFire;
        this.shouldPlaySmoke = shouldPlaySmoke;
        this.shouldBreakBlocks = shouldBreakBlocks;
        this.shouldDamageEntities = shouldDamageEntities;
    }

    @Override
    public Optional<WSExplosive> getSourceExplosive() {
        return Optional.ofNullable(this.explosive);
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public boolean canCauseFire() {
        return this.canCauseFire;
    }

    @Override
    public boolean shouldPlaySmoke() {
        return this.shouldPlaySmoke;
    }

    @Override
    public boolean shouldBreakBlocks() {
        return this.shouldBreakBlocks;
    }

    @Override
    public boolean shouldDamageEntities() {
        return this.shouldDamageEntities;
    }

    @Override
    public Builder toBuilder() {
        return null;
    }

    @Override
    public Object getHandler() {
        return null;
    }

    @Override
    public WSLocation getLocation() {
        return this.location.clone();
    }

    @Override
    public WSWorld getWorld() {
        return this.getLocation().getWorld();
    }

    public static class Builder
    implements WSExplosion.Builder {
        private WSExplosive explosive = null;
        private WSLocation location = null;
        private float radius;
        private boolean canCauseFire;
        private boolean shouldPlaySmoke;
        private boolean shouldBreakBlocks;
        private boolean shouldDamageEntities;

        @Override
        public WSExplosion.Builder location(WSLocation location) {
            this.location = location;
            return this;
        }

        @Override
        public WSExplosion.Builder sourceExplosive(@Nullable WSExplosive explosive) {
            this.explosive = explosive;
            return this;
        }

        @Override
        public WSExplosion.Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        @Override
        public WSExplosion.Builder canCauseFire(boolean canCauseFire) {
            this.canCauseFire = canCauseFire;
            return this;
        }

        @Override
        public WSExplosion.Builder shouldDamageEntities(boolean shouldDamageEntities) {
            this.shouldDamageEntities = shouldDamageEntities;
            return this;
        }

        @Override
        public WSExplosion.Builder shouldPlaySmoke(boolean shouldPlaySmoke) {
            this.shouldPlaySmoke = shouldPlaySmoke;
            return this;
        }

        @Override
        public WSExplosion.Builder shouldBreakBlocks(boolean shouldBreakBlocks) {
            this.shouldBreakBlocks = shouldBreakBlocks;
            return this;
        }

        @Override
        public WSExplosion build() {
            return new SpigotExplosion(this.explosive, this.location, this.radius, this.canCauseFire, this.shouldPlaySmoke, this.shouldBreakBlocks, this.shouldDamageEntities);
        }
    }
}

