/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.world;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.Spigot13Entity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBiomeType;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.enums.EnumMapBaseColor;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.map.WSMapView;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.mixin.spigot.Spigot13WSEntityHumanAssist;
import com.degoos.wetsponge.parser.entity.Spigot13EntityParser;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.degoos.wetsponge.util.reflection.Spigot13MapUtils;
import com.degoos.wetsponge.world.Spigot13Chunk;
import com.degoos.wetsponge.world.Spigot13WorldBorder;
import com.degoos.wetsponge.world.Spigot13WorldInjector;
import com.degoos.wetsponge.world.Spigot13WorldProperties;
import com.degoos.wetsponge.world.WSChunk;
import com.degoos.wetsponge.world.WSExplosion;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import com.degoos.wetsponge.world.WSWorldBorder;
import com.degoos.wetsponge.world.WSWorldProperties;
import com.degoos.wetsponge.world.generation.WSWorldGenerator;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class Spigot13World
implements WSWorld {
    private World world;
    private WSWorldProperties worldProperties;
    private Object chunkProvider;
    private Object chunkLoader;
    private WSWorldBorder worldBorder;
    private Map<Integer, WSMapView> mapViews;

    public Spigot13World(Object world) {
        this((World)world);
    }

    public Spigot13World(World world) {
        Validate.notNull(world, "World cannot be null!");
        this.world = world;
        this.worldBorder = new Spigot13WorldBorder(world.getWorldBorder());
        this.mapViews = new HashMap<Integer, WSMapView>();
        this.worldProperties = new Spigot13WorldProperties(world);
        this.chunkProvider = Spigot13WorldInjector.inject(world);
        try {
            this.chunkLoader = ReflectionUtils.getFirstObject(NMSUtils.getNMSClass("ChunkProviderServer"), NMSUtils.getNMSClass("IChunkLoader"), this.chunkProvider);
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An exception has occurred while WetSponge was loading a world.");
        }
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public Set<WSEntity> getEntities() {
        return this.world.getEntities().stream().map(Spigot13EntityParser::getWSEntity).collect(Collectors.toSet());
    }

    @Override
    public Set<WSPlayer> getPlayers() {
        return this.getHandled().getPlayers().stream().map(player -> PlayerParser.getOrCreatePlayer(player, player.getUniqueId())).collect(Collectors.toSet());
    }

    @Override
    public UUID getUniqueId() {
        return this.world.getUID();
    }

    @Override
    public <T extends WSEntity> Optional<T> spawnEntity(Class<T> entityClass, Vector3d location) {
        WetSponge.getTimings().startTiming("Spawn entity");
        try {
            Optional<WSEntity> entity = this.createEntity(entityClass, location);
            entity.ifPresent(this::spawnEntity);
            WetSponge.getTimings().stopTiming();
            return entity;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was spawning an entity!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public Optional<WSEntity> spawnEntity(EnumEntityType type, Vector3d location) {
        WetSponge.getTimings().startTiming("Spawn entity");
        try {
            Optional<WSEntity> entity = this.createEntity(type, location);
            entity.ifPresent(this::spawnEntity);
            WetSponge.getTimings().stopTiming();
            return entity;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was spawning an entity!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public boolean spawnEntity(WSEntity entity) {
        WetSponge.getTimings().startTiming("Spawn entity");
        try {
            NMSUtils.getOBCClass("CraftWorld").getMethod("addEntity", NMSUtils.getNMSClass("Entity"), CreatureSpawnEvent.SpawnReason.class).invoke((Object)this.world, Spigot13HandledUtils.getEntityHandle(((Spigot13Entity)entity).getHandled()), CreatureSpawnEvent.SpawnReason.CUSTOM);
            WetSponge.getTimings().stopTiming();
            return true;
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was spawning an entity!");
            WetSponge.getTimings().stopTiming();
            return false;
        }
    }

    @Override
    public <T extends WSEntity> Optional<T> createEntity(Class<T> entityClass, Vector3d location) {
        return this.createEntity(EnumEntityType.getByClass(entityClass).orElse(EnumEntityType.UNKNOWN), location);
    }

    @Override
    public Optional<WSEntity> createEntity(EnumEntityType type, Vector3d location) {
        WetSponge.getTimings().startTiming("Create entity");
        if (type == EnumEntityType.UNKNOWN) {
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
        try {
            Object entity;
            Class<? extends Entity> spigotClass = Spigot13EntityParser.getEntityData(type).getEntityClass();
            if (type == EnumEntityType.ITEM) {
                Object worldHandled = Spigot13HandledUtils.getWorldHandle(this.world);
                entity = NMSUtils.getNMSClass("EntityItem").getConstructor(NMSUtils.getNMSClass("World"), Double.TYPE, Double.TYPE, Double.TYPE).newInstance(worldHandled, location.getX(), location.getY(), location.getZ());
            } else {
                entity = ReflectionUtils.getMethodByName(NMSUtils.getOBCClass("CraftWorld"), "createEntity").invoke((Object)this.world, new Location(this.world, location.getX(), location.getY(), location.getZ()), spigotClass);
            }
            Entity bukkitEntity = entity == null ? null : (Entity)entity.getClass().getMethod("getBukkitEntity", new Class[0]).invoke(entity, new Object[0]);
            Optional<WSEntity> optionalEntity = Optional.ofNullable(bukkitEntity).map(Spigot13EntityParser::getWSEntity);
            WetSponge.getTimings().stopTiming();
            return optionalEntity;
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was creating an entity!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public Optional<WSHuman> createNPC(WSGameProfile gameProfile, Vector3d vector3d) {
        WetSponge.getTimings().startTiming("Create entity");
        try {
            Class<?> worldClass = NMSUtils.getNMSClass("World");
            Object world = Spigot13HandledUtils.getWorldHandle(this.world);
            Object player = Spigot13WSEntityHumanAssist.ENTITY_HUMAN_CLASS.getConstructor(worldClass, gameProfile.getHandled().getClass()).newInstance(world, gameProfile.getHandled());
            HumanEntity bukkitPlayer = (HumanEntity)player.getClass().getMethod("getBukkitEntity", new Class[0]).invoke(player, new Object[0]);
            WSEntity entity = Spigot13EntityParser.getWSEntity((Entity)bukkitPlayer);
            if (!(entity instanceof WSHuman)) {
                return Optional.empty();
            }
            WetSponge.getTimings().stopTiming();
            return Optional.ofNullable((WSHuman)entity);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating a NPC!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public WSWorldProperties getProperties() {
        return this.worldProperties;
    }

    @Override
    public WSWorldGenerator getGenerator() {
        return (WSWorldGenerator)this.world.getGenerator();
    }

    @Override
    public Optional<WSChunk> getChunk(int x, int z) {
        return Optional.ofNullable(this.world.getChunkAt(x, z)).map(Spigot13Chunk::new);
    }

    @Override
    public Optional<WSChunk> getChunkAtLocation(int x, int z) {
        return Optional.ofNullable(this.world.getChunkAt(x >> 4, z >> 4)).map(Spigot13Chunk::new);
    }

    @Override
    public Optional<WSChunk> loadChunk(int x, int z, boolean shouldGenerate) {
        try {
            WetSponge.getTimings().startTiming("Load chunk");
            this.world.loadChunk(x, z, shouldGenerate);
            Optional<WSChunk> chunk = this.getChunk(x, z);
            WetSponge.getTimings().stopTiming();
            return chunk;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was loading a chunk!");
            WetSponge.getTimings().stopTiming();
            return Optional.empty();
        }
    }

    @Override
    public Optional<WSChunk> loadChunkAtLocation(int x, int z, boolean shouldGenerate) {
        return this.loadChunk(x >> 4, z >> 4, shouldGenerate);
    }

    @Override
    public Set<WSChunk> getLoadedChunks() {
        return Arrays.stream(this.world.getLoadedChunks()).map(Spigot13Chunk::new).collect(Collectors.toSet());
    }

    @Override
    public EnumBiomeType getBiome(int x, int y, int z) {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return EnumBiomeType.getBySpigotName(this.world.getBiome(x, z).name()).orElseThrow(NullPointerException::new);
        }
        return EnumBiomeType.getByOldSpigotName(this.world.getBiome(x, z).name()).orElseThrow(NullPointerException::new);
    }

    @Override
    public void setBiome(int x, int y, int z, EnumBiomeType biome) {
        this.world.setBiome(x, z, Biome.valueOf((String)(WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? biome.getSpigotName() : biome.getOldSpigotName())));
    }

    @Override
    public boolean isAutoSave() {
        return this.world.isAutoSave();
    }

    @Override
    public void setAutoSave(boolean autoSave) {
        this.world.setAutoSave(autoSave);
    }

    @Override
    public void save() {
        this.world.save();
    }

    @Override
    public void flushUnloadedChunksQueue() {
        try {
            this.chunkProvider.getClass().getMethod("unloadChunks", new Class[0]).invoke(this.chunkProvider, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void shutdownAllChunks() {
        try {
            ReflectionUtils.invokeMethod(ReflectionUtils.getObject(this.chunkProvider, "chunks"), "clear", new Object[0]);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was unloading all chunks of the world " + this.world.getName());
        }
    }

    @Override
    public boolean canBeSaved() {
        try {
            return (Boolean)this.chunkProvider.getClass().getField("canSave").get(this.chunkProvider);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return true;
        }
    }

    @Override
    public void setCanBeSaved(boolean canSave) {
        try {
            this.chunkProvider.getClass().getField("canSave").set(this.chunkProvider, canSave);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void saveAllChunks() {
        try {
            Method flush;
            Object nmsWorld = Spigot13HandledUtils.getWorldHandle(this.world);
            Collection collection = (Collection)ReflectionUtils.invokeMethod(this.chunkProvider, "a", new Object[0]);
            if (collection == null) {
                InternalLogger.sendWarning("Cannot save chunks! Collection is null.");
                return;
            }
            boolean newVersion = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD);
            Method method = newVersion ? ReflectionUtils.getMethod(this.chunkLoader.getClass(), "saveChunk", nmsWorld.getClass(), NMSUtils.getNMSClass("Chunk"), Boolean.TYPE) : ReflectionUtils.getMethod(this.chunkLoader.getClass(), "a", nmsWorld.getClass(), NMSUtils.getNMSClass("Chunk"));
            int i = 0;
            try {
                for (Object chunk : collection) {
                    if (newVersion) {
                        method.invoke(this.chunkLoader, nmsWorld, chunk, false);
                    } else {
                        method.invoke(this.chunkLoader, nmsWorld, chunk);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                InternalLogger.sendWarning("Error while saving chunks. Chunks saved: " + i);
            }
            Method method2 = flush = newVersion ? ReflectionUtils.getMethod(this.chunkLoader.getClass(), "a", new Class[0]) : ReflectionUtils.getMethod(this.chunkLoader.getClass(), "c", new Class[0]);
            if (newVersion) {
                while (((Boolean)flush.invoke(this.chunkLoader, new Object[0])).booleanValue()) {
                }
            } else {
                while (((Boolean)flush.invoke(this.chunkLoader, new Object[0])).booleanValue()) {
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was trying to save the chunks of the world" + this.getName());
        }
    }

    @Override
    public WSBlockType getBlockType(Vector3i position) {
        return this.getBlockType(position.getX(), position.getY(), position.getZ());
    }

    @Override
    public WSBlockType getBlockType(int x, int y, int z) {
        try {
            return Spigot13HandledUtils.getMaterial(ReflectionUtils.invokeMethod(ReflectionUtils.invokeMethod(Spigot13HandledUtils.getWorldHandle(this.world), "getChunkAt", x >> 4, z >> 4), "getBlockState", x, y, z));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the block types of a block!");
            return null;
        }
    }

    @Override
    public Map<Vector3i, WSBlockType> getBlockTypesInArea(Vector3i pos1, Vector3i pos2) {
        return this.getBlockTypesInArea(pos1, pos2, false);
    }

    @Override
    public Map<Vector3i, WSBlockType> getBlockTypesInArea(Vector3i pos1, Vector3i pos2, boolean getAir) {
        WetSponge.getTimings().startTiming("Get block types in area");
        Vector3i min2 = new Vector3i(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()));
        Vector3i max = new Vector3i(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()));
        Vector2i minChunk = new Vector2i(min2.getX() >> 4, min2.getZ() >> 4);
        Vector2i maxChunk = new Vector2i(max.getX() >> 4, max.getZ() >> 4);
        HashMap<Vector3i, WSBlockType> blockTypes = new HashMap<Vector3i, WSBlockType>();
        try {
            Object nmsWorld = Spigot13HandledUtils.getWorldHandle(this.world);
            for (int cx = minChunk.getX(); cx <= maxChunk.getX(); ++cx) {
                for (int cz = minChunk.getY(); cz <= maxChunk.getY(); ++cz) {
                    Object chunk = this.loadChunk(nmsWorld, cx, cz);
                    if (chunk == null) {
                        InternalLogger.sendWarning("Cannot load chunk (" + cx + ", " + cz + ")! WetSponge will skip it. (Method: getBlockTypesInArea)");
                        continue;
                    }
                    int minX = 0;
                    int minZ = 0;
                    int maxX = 15;
                    int maxZ = 15;
                    if (cx == minChunk.getX()) {
                        minX = min2.getX() - (cx << 4);
                    }
                    if (cz == minChunk.getY()) {
                        minZ = min2.getZ() - (cz << 4);
                    }
                    if (cx == maxChunk.getX()) {
                        maxX = max.getX() - (cx << 4);
                    }
                    if (cz == maxChunk.getY()) {
                        maxZ = max.getZ() - (cz << 4);
                    }
                    for (int x = minX; x <= maxX; ++x) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            for (int y = min2.getY(); y <= max.getY(); ++y) {
                                int fx = (cx << 4) + x;
                                int fz = (cz << 4) + z;
                                WSBlockType blockType = Spigot13HandledUtils.getMaterial(ReflectionUtils.invokeMethod(chunk, "getBlockData", fx, y, fz));
                                if (!getAir && blockType.getStringId().equalsIgnoreCase(WSBlockTypes.AIR.getStringId())) continue;
                                blockTypes.put(new Vector3i(fx, y, fz), blockType);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the block types of an area!");
        }
        WetSponge.getTimings().stopTiming();
        return blockTypes;
    }

    @Override
    public Map<Vector2i, EnumMapBaseColor> getMapColors(Vector3i pos1, Vector3i pos2) {
        WetSponge.getTimings().startTiming("Get map colors");
        Vector3i min2 = new Vector3i(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()));
        Vector3i max = new Vector3i(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()));
        Vector2i minChunk = new Vector2i(min2.getX() >> 4, min2.getZ() >> 4);
        Vector2i maxChunk = new Vector2i(max.getX() >> 4, max.getZ() >> 4);
        HashMap<Vector2i, EnumMapBaseColor> colors = new HashMap<Vector2i, EnumMapBaseColor>();
        try {
            Class<?> chunkClass = NMSUtils.getNMSClass("Chunk");
            Class<?> blockPosClass = NMSUtils.getNMSClass("BlockPosition");
            Method getBlockData = chunkClass.getMethod("getBlockData", blockPosClass);
            Constructor<?> blockPosConstructor = blockPosClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object nmsWorld = Spigot13HandledUtils.getWorldHandle(this.world);
            int total = 0;
            for (int cx = minChunk.getX(); cx <= maxChunk.getX(); ++cx) {
                for (int cz = minChunk.getY(); cz <= maxChunk.getY(); ++cz) {
                    ++total;
                }
            }
            int count = 0;
            for (int cx = minChunk.getX(); cx <= maxChunk.getX(); ++cx) {
                for (int cz = minChunk.getY(); cz <= maxChunk.getY(); ++cz) {
                    Object chunk = this.loadChunk(nmsWorld, cx, cz);
                    if (++count % 5 == 0) {
                        InternalLogger.sendInfo("Saving map colors. " + count + "/" + total + " (" + (count - 1) * 100 / total + "%)");
                    }
                    if (chunk == null) {
                        InternalLogger.sendWarning("Cannot load chunk (" + cx + ", " + cz + ")! WetSponge will skip it. (Method: getMapColors)");
                        continue;
                    }
                    int minX = 0;
                    int minZ = 0;
                    int maxX = 15;
                    int maxZ = 15;
                    if (cx == minChunk.getX()) {
                        minX = min2.getX() - (cx << 4);
                    }
                    if (cz == minChunk.getY()) {
                        minZ = min2.getZ() - (cz << 4);
                    }
                    if (cx == maxChunk.getX()) {
                        maxX = max.getX() - (cx << 4);
                    }
                    if (cz == maxChunk.getY()) {
                        maxZ = max.getZ() - (cz << 4);
                    }
                    for (int x = minX; x <= maxX; ++x) {
                        block7: for (int z = minZ; z <= maxZ; ++z) {
                            for (int y = max.getY(); y >= min2.getY(); --y) {
                                int fx = (cx << 4) + x;
                                int fz = (cz << 4) + z;
                                Object nmsBT = getBlockData.invoke(chunk, blockPosConstructor.newInstance(fx, y, fz));
                                WSBlockType blockType = Spigot13HandledUtils.getMaterial(nmsBT);
                                EnumMapBaseColor color = Spigot13MapUtils.getMapBaseColor(nmsBT, nmsWorld, Spigot13HandledUtils.getBlockPosition(fx, y, fz), blockType.getStringId());
                                if (color.equals((Object)EnumMapBaseColor.AIR)) continue;
                                colors.put(new Vector2i(fx, fz), color);
                                continue block7;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the block types of an area!");
        }
        WetSponge.getTimings().stopTiming();
        return colors;
    }

    private Object loadChunk(Object nmsWorld, int cx, int cz) {
        WetSponge.getTimings().startTiming("Load nms chunk");
        try {
            Object o = ReflectionUtils.invokeMethod(this.chunkLoader, "loadChunk", nmsWorld, cx, cz);
            if (o == null) {
                return null;
            }
            WetSponge.getTimings().stopTiming();
            return Array.get(o, 0);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was loading a chunk!");
            WetSponge.getTimings().stopTiming();
            return null;
        }
    }

    @Override
    public void triggerExplosion(WSExplosion explosion) {
        WSLocation location = explosion.getLocation();
        this.world.createExplosion(location.getX(), location.getY(), location.getZ(), explosion.getRadius(), explosion.canCauseFire(), explosion.shouldBreakBlocks());
    }

    @Override
    public WSWorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public Map<Integer, WSMapView> getMapViews() {
        return new HashMap<Integer, WSMapView>(this.mapViews);
    }

    @Override
    public Optional<WSMapView> getMapView(int mapId) {
        return Optional.ofNullable(this.mapViews.getOrDefault(mapId, null));
    }

    @Override
    public void putMapView(int mapId, WSMapView mapView) {
        Validate.notNull(mapView, "Map view cannot be null!");
        this.mapViews.put(mapId, mapView);
    }

    @Override
    public void removeMapView(int mapId) {
        this.mapViews.remove(mapId);
    }

    @Override
    public void clearMapViews() {
        this.mapViews.clear();
    }

    @Override
    public File getWorldFolder() {
        return this.world.getWorldFolder();
    }

    @Override
    public Object getChunkProvider() {
        return this.chunkProvider;
    }

    public World getHandled() {
        return this.world;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13World that = (Spigot13World)o;
        return this.world != null ? this.world.equals(that.world) : that.world == null;
    }

    public int hashCode() {
        return this.world != null ? this.world.hashCode() : 0;
    }
}

