/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.util.reflection;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SpigotHandledUtils {
    public static Object getWorldHandle(World w) {
        try {
            return w.getClass().getMethod("getHandle", new Class[0]).invoke((Object)w, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerHandle(Player pl) {
        return SpigotHandledUtils.getEntityHandle((Entity)pl);
    }

    public static Object getEntityHandle(Entity entity) {
        try {
            return entity.getClass().getMethod("getHandle", new Class[0]).invoke((Object)entity, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getServerHandle(Object object) {
        try {
            return object.getClass().getMethod("getServer", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getHandle(Object object) {
        try {
            return object.getClass().getMethod("getHandle", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getBlockPosition(Location loc) {
        return SpigotHandledUtils.getBlockPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Object getBlockPosition(Vector3d loc) {
        return SpigotHandledUtils.getBlockPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Object getBlockPosition(Vector3i loc) {
        return SpigotHandledUtils.getBlockPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Object getBlockPosition(double x, double y, double z) {
        try {
            return NMSUtils.getNMSClass("BlockPosition").getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(x, y, z);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Object getBlockPosition(int x, int y, int z) {
        try {
            return NMSUtils.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(x, y, z);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Vector3i getBlockPositionVector(Object position) {
        try {
            return new Vector3i((Integer)position.getClass().getMethod("getX", new Class[0]).invoke(position, new Object[0]), (Integer)position.getClass().getMethod("getY", new Class[0]).invoke(position, new Object[0]), (Integer)position.getClass().getMethod("getZ", new Class[0]).invoke(position, new Object[0]));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getBlockState(WSBlockType material) {
        try {
            Class<?> blockClass = NMSUtils.getNMSClass("Block");
            Object block = blockClass.getMethod("getById", Integer.TYPE).invoke(null, material.getNumericalId());
            return blockClass.getMethod("fromLegacyData", Integer.TYPE).invoke(block, ((SpigotBlockType)material).toMaterialData().getData());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WSBlockType getMaterial(Object blockState) {
        try {
            Class<?> iBlockStateClass = NMSUtils.getNMSClass("IBlockData");
            Class<?> blockClass = NMSUtils.getNMSClass("Block");
            Class<?> registryClass = NMSUtils.getNMSClass("RegistryBlocks");
            Object block = iBlockStateClass.getMethod("getBlock", new Class[0]).invoke(blockState, new Object[0]);
            Object registry = blockClass.getField("REGISTRY").get(null);
            int id = (Integer)ReflectionUtils.getMethod(registryClass, WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_9) ? "b" : "a", blockClass).invoke(registry, block);
            int data = (Integer)blockClass.getMethod("toLegacyData", iBlockStateClass).invoke(block, blockState);
            return ((SpigotBlockType)WSBlockTypes.getById(id).orElse(new SpigotBlockType(id, "", "", 64))).readMaterialData(Material.getMaterial((int)id).getNewData((byte)data));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

