/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.util.blockray;

import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.bridge.util.blockray.BridgeBlockRay;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector3d;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;

public interface WSBlockRay
extends Iterator<WSBlock> {
    public static final Predicate<WSBlockType> ALL_BLOCKS = wsBlockType -> true;
    public static final Predicate<WSBlockType> ONLY_AIR = wsBlockType -> wsBlockType.getStringId().equalsIgnoreCase(WSBlockTypes.AIR.getStringId());

    public static Predicate<WSBlockType> blockTypeFilter(WSBlockType type) {
        return wsBlockType -> wsBlockType.equals(type);
    }

    public static Builder builder(WSWorld world) {
        return BridgeBlockRay.builder(world);
    }

    public static WSBlockRay of(WSLivingEntity entity, double maxDistance, Predicate<WSBlockType> skipFilter) {
        WSLocation location = entity.getLocation();
        return WSBlockRay.builder(entity.getWorld()).origin(location.toVector3d()).direction(location.getFacingDirection()).maxDistance(maxDistance).yOffset(entity.getEyeHeight()).skipFilter(skipFilter).build();
    }

    public Optional<WSBlock> end();

    public static interface Builder {
        public Builder origin(Vector3d var1);

        public Builder direction(Vector3d var1);

        public Builder yOffset(double var1);

        public Builder maxDistance(double var1);

        public Builder skipFilter(Predicate<WSBlockType> var1);

        public WSBlockRay build();
    }
}

