/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.user;

import com.degoos.wetsponge.bridge.user.BridgeGameProfile;
import com.degoos.wetsponge.user.WSProfileProperty;
import com.degoos.wetsponge.util.Validate;
import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.UUID;

public interface WSGameProfile {
    public static WSGameProfile of(UUID uniqueId) {
        return WSGameProfile.of(uniqueId, null);
    }

    public static WSGameProfile of(UUID uniqueId, String name) {
        return BridgeGameProfile.of(uniqueId, name);
    }

    public UUID getId();

    public Optional<String> getName();

    public Multimap<String, WSProfileProperty> getPropertyMap();

    default public WSGameProfile addProperty(WSProfileProperty property) {
        Validate.notNull(property, "Property cannot be null!");
        return this.addProperty(property.getName(), property);
    }

    public WSGameProfile addProperty(String var1, WSProfileProperty var2);

    default public boolean removeProperty(WSProfileProperty property) {
        Validate.notNull(property, "Property cannot be null!");
        return this.getPropertyMap().remove(property.getName(), property);
    }

    default public boolean removeProperty(String name, WSProfileProperty property) {
        Validate.notNull(name, "Name cannot be null!");
        Validate.notNull(property, "Property cannot be null!");
        return this.getPropertyMap().remove(name, property);
    }

    public boolean isFilled();

    public Object getHandled();
}

